#include "mbed.h"

DigitalOut myled(LED_GREEN); //Parpadear led;
Serial pc(USBTX, USBRX); //Configurar salida serial para PC;
AnalogIn volt(PTB2); //Configirar puerto análogo;
Serial bt(PTE0,PTE1);  //puertos del FRDM para el modem bluetooth;
PwmOut PWM1(PTB3); //Configuro una salida PWM; 
int main()
{
    bt.baud(9600);   // asigno baudios y configuro puerto serie de la usart
    bt.format(8,Serial::None,1); //8bits - No parity bit - one stop bit
    int i = 0;
    int lectura =0; //Variable para leer desde el BT
    float voltaje=0; //Voltaje como float;
    float periodo = 0; //Periodo;
    int voltint; //Voltaje como entero
    float dutyC =0; //Ciclo de dureza;  
    //int comando=0; //Variable que usaré para saber qué parámetro está siendo enviado;
    pc.printf("Digital voltmeter using KL25z: \n\r Ing. Pablo Viana\n\r ");
    //bt.printf("Digital voltmeter using KL25z: \n\r Ing. Pablo Viana\n\r ");
    while (true) 
    { //Loop...
        voltaje = volt*3.3; //Leo el valor de la entrada analógica;
        voltint=volt*255;//Convierto a entero;
        
        wait(0.5); // wait a small period of time
        pc.printf("Voltage: %f \r\n", voltaje); // print the value of variable i
        i++; // increment the variable
        myled = !myled; // toggle a led
        
        /*Escribir en el bluetooth para enviar al appInventor*/
         if(voltint<256)
            {           //debo generar dos casos a APP inventor solo me recibe hex asi: 0xhhhh (4 cifras)    
           //bt.putc(0);     //si el numero es hasta 255 se le ponen dos ceros adelante a la secuencia de bits
           bt.putc(voltint);     //luego la cifra menos significativa
            }
            
            //Leer información del bluetooth
       if (bt.readable())
       {    
            
            lectura = bt.getc(); //Leo el valor del bluetooth;
            pc.printf("%i", lectura);
            wait(1);
            if (lectura <101)
            {
                dutyC=lectura/100.0; //calculo el ciclo de dureza;
                PWM1.write(dutyC);
                pc.printf("DC: %f\n\r", dutyC);
                wait(1);
            }
            
            if (lectura >100)
            {
                periodo=1.0/lectura; //Calocular periodo del PWM;
                PWM1.period (periodo);
                
                pc.printf("Periodo: %f\n\r", periodo);
                wait(1);
            }        

        }
 
        
       
    }
}
