#include "mbed.h"
#include "AM2320.h"
#include "OUTS.h"
#include "INPUTS.h"
//#include "TextLCD.h"

Timer t;

AM2320 senzor (PB_9, PB_8);
OUTS izlazi (PC_10, PC_12, PC_1, PC_0);
INPUTS ulazi (PC_2, PC_3);
Serial pc(USBTX, USBRX);
//TextLCD lcd (A0,A1,A2,A3,A4,A5);



int main() {
    
    float trazena_temperatura, trazena_vlaga, senzor_vlaga, senzor_temperatura;
    t.start();
    while (true) {
        
        trazena_temperatura = ulazi.get_temp_req();
        trazena_vlaga = ulazi.get_hum_req();
        senzor_vlaga = (float)senzor.humidity()/10;
        senzor_temperatura = (float)senzor.temperature()/10;
        izlazi.outs_on(senzor_temperatura, senzor_vlaga, trazena_temperatura, trazena_vlaga);
        
        if (t.read()>2){
            
            pc.printf("Trazena temperatura: %.1f C\nTrazena vlaga: %.1f %%RH\n\n", trazena_temperatura, trazena_vlaga);
            pc.printf("Trenutna temperatura: %.1f C\nTrenutna vlaga: %.1f %%RH\n_____________________________________________\n", senzor_temperatura, senzor_vlaga);
            t.reset();
        }
        
        
    }
}