#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial Light_serial_port(PC_10, PC_11);//pinout 476RG

/*
Différent montage en réception en fonction du choix de l'emission du signal :

Dans tous les cas le code reste le même, sauf pinout si tu changes de carte.
Le code est aussi l'exemple de la nouvelle façon de réceptionner le signal d'un port série, lumière ou pas...

Pour Solution 1 ==> Récepteur IR à 3 pattes

PC_11 / RX ------------- Recpteur IR de face -------------- 3,3v ou 5v..mettre une R
                            |
                            |
                            |
                            |
                            |
                           GND


Pour Solution 2 et 3 ==> Récepteur photodiodes IR ou spectre complet, il faut fabriquer une 3 ème patte à la photodiode...

3,3v -----------------Photodiode-----------------------PC_11 / RX
                                       |
                                       |
                                       |
                                    R = 1 kΩ
                                       |
                                       |
                                       |
                                      GND

*/
const int Buffer_size = 25;//a adapter au message reçu de préférence (ici pour le Cozir H, T, Z finissant par \n)
char Light_message[Buffer_size];
int bytes_Recieved;
bool newMessageFlag  = false;

void callback_Light_Message()
{
    while(Light_serial_port.readable()) {
        if ((bytes_Recieved  == Buffer_size) || newMessageFlag) //éviter la saturation du buffer
            Light_serial_port.getc();
        else
            Light_message [bytes_Recieved++] = Light_serial_port.getc();//chargement du buffer dans le message
        if ((bytes_Recieved == Buffer_size) || (Light_message[bytes_Recieved-1] == '\n')) {//le message est complet ou nouvelle ligne ou autre si on veut...
            Light_message[bytes_Recieved] = 0;
            newMessageFlag  = true;
        }
    }
}

void decoding_Message(char message [])
{
    //Ici je décode pas, mais on ferait le décodage du message si ion voulait...
    pc.printf("Light message = %s", Light_message);
}

int main()
{

    Light_serial_port.attach(&callback_Light_Message, Serial::RxIrq);
    pc.printf("Start Listening light port....\r\n");
    
    //Attention, a mettre en adéquation avec la partie emission
    Light_serial_port.baud(9600);
    
    while(1) {

        if (newMessageFlag) {
            decoding_Message(Light_message);
            strcpy(Light_message," ");
            bytes_Recieved = 0;
            newMessageFlag  = false;
        }

    }
}
