/* -- MBED - AD7190

Porting by Rododo Science. .... 2019/9/13

-- */


#include "mbed.h"
#include "AD7190.h"
SPI spi(D11, D12, D13); // mosi, miso, sclk
DigitalOut cs(D10);      // Different CS operations
DigitalIn  ad_rdy(D9);  // Use of a _RDY Pin

Serial uart(PC_4, PC_5);//TX4,RX4
int idx=0;

Serial pc(USBTX, USBRX); // tx, rx

void setup()
{
    cs.write(1);
    wait(1);
    pc.printf("Example Start\n");
    cs.write(0);
    while(AD7190_Init(800)==0){
    pc.printf("Can't allocate AD7190\n");
    wait(5);
    }

    /* Calibrates channel AIN3(+) - AIN4(-).  */ 
    AD7190_Calibrate(AD7190_MODE_CAL_INT_ZERO, AD7190_CH_AIN3P_AIN4M);

}

void loop()
{

    unsigned long val = AD7190_TemperatureRead();
    //pc.printf("Temperature = \t =%lu \r\n", val);

    AD7190_ChannelSelect(AD7190_CH_AIN1P_AIN2M);
    /* Selects unipolar operation and ADC's input range to +-Vref/1. plesase refer AD7190_CONF_GAIN(x) */
    AD7190_RangeSetup(0, AD7190_CONF_GAIN_64);
    
    //val = AD7190_SingleConversion();
    //pc.printf("ADC = \t%lu \r\n", val);

    val = AD7190_ContinuousReadAvg(8);
    //pc.printf("ADC_avg = \t%lu \r\n", val);
    
    double voltageAn34 =  ( val * 0.00000011921 - 1 ) * 4.096 /64 ; //AIN=(輸出碼/2^23-1)*(Vref/gain)
   
    
    pc.printf("%f \r\n", voltageAn34);
    
     uart.printf("s%f# \r\n", voltageAn34);
   
    idx=idx+1;
    wait(0.01);
    //pc.printf("TX send s %f #\r\n",voltageAn34);
    //wait(1);
  

}


//---DON'T CHANGE BELOW----
// MBED compensate
// main() runs in its own thread in the OS
int main() {
    //---Enable Debug---
    pc.baud(9600);
    uart.baud(9600);
    //--Mark out to disable debug
    setup();
    while (true) {
        loop();
        
            
    }
}
