#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;
DigitalOut myled(LED1);

int main() {
    
    printf("RTC example\n"); 
    set_time(1539982753);  // Set RTC time to Friday, October 19, 2018 1:59:13 PM GMT-07:00 DST
    printf("Date and time are set.\n");
    BSP_LCD_SetFont(&Font12);

    while(1) {

wait(2.0);
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    wait(0.3);
    lcd.DisplayStringAt(0, LINE(4), (uint8_t *)"DISCOVERY", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"STM32F429ZI", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"Test Nucleo", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"RTC Function", CENTER_MODE);
    wait(1);

        time_t seconds = time(NULL);

        lcd.DisplayStringAt(0, LINE(9), (uint8_t *)ctime(&seconds), CENTER_MODE);        

        myled = !myled;      
        wait(1);
    }
}
