/*
 * IRSensor.h
 * Copyright (c) 2016, ZHAW
 * All rights reserved.
 */

//#pragma once


#ifndef IS_H_
#define IS_H_


#include <cstdlib>
#include <mbed.h>

/**
 * This is a device driver class to read the distance measured with a Sharp IR sensor.
 */
class IRSensor
{

public:

    IRSensor(AnalogIn* distance,AnalogIn* distance2, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
    IRSensor();
    
    void        init(AnalogIn* distance,AnalogIn* distance2, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
    virtual     ~IRSensor();
    float       read();

    operator float();

private:

    AnalogIn*       distance;
    AnalogIn*       distance2;
    DigitalOut*     bit0;
    DigitalOut*     bit1;
    DigitalOut*     bit2;

    int             number;
};

#endif

