#include "mbed.h"

BusOut leds(LED1, LED2, LED3, LED4);
InterruptIn sw1(p14);    // Joy Stick Center
enum State {ST_START, ST_EIN, ST_AUS, ST_ENDE};
State state;
int btnCount = 0; 

class IsAnEvent : public InterruptIn {
        volatile int16_t _pressed;
        void _RisingISR(); 
    public:
        IsAnEvent() : InterruptIn(p15) {};
        IsAnEvent(PinName pin) : InterruptIn(pin) {
             rise(callback(this, &IsAnEvent::_RisingISR)); 
            _pressed=0; 
        };
        int CheckFlag();
        void InitIsr();
};

void IsAnEvent::InitIsr() { 
    rise(callback(this, &IsAnEvent::_RisingISR)); 
}

void IsAnEvent::_RisingISR() {
    wait_ms(50);
    if( read() )
        _pressed = true;
}
int IsAnEvent::CheckFlag() {
    if( _pressed ) { 
        _pressed = false; 
        return 1; 
    }
    return 0;
}

// ----------------- Stm Klasse ------------------

class Stm {
  public:
        Stm() { state=ST_AUS; }
        
        void Start();
        void LedOn();
        void LedOff();
        void Ende();
};

void Stm::Start(){
    leds = 15;
    wait_ms(500);
    leds = 0;    
}

void Stm::LedOn(){
    while(true) {
        if(sw1.CheckFlag()) {
            state = ST_AUS;
            return;
        }
    }
}
 
void Stm::LedOff(){
    while(true) {
        leds = 0;
        if(sw1.CheckFlag()) {
            state = ST_EIN;
            return;
        }
    }
}

Stm stm;
 
void stateMachine()
{
    switch (stm.state)
    {
    case ST_START: stm.Start();
        break;
    case ST_EIN: stm.Ein();
        break;
    case ST_AUS: stm.Aus();
        break;
    case STM_ENDE: stm.Ende();
    default: stm.Error();
        break;
    }
}
 
int main()
{
    printf("Hello STM class\n");
    sw1.InitIsr();
 
    while(1) {
        stateMachine(); 
    }
}