#include "mbed.h"
#include "C12832.h"

DigitalOut trig(p21); //definition of the input signal.
DigitalIn echo(p22); //definition of the input signal.

DigitalOut led1(LED1); // defines the led 1 used to show the trigger signal is happening.
DigitalOut led2(LED2); // defines the led 2 used to show the echo signal is happening.
DigitalOut led4(LED4); //defines the led 1 used to show the buzzer is turned on or off.

C12832 lcd(p5, p7, p6, p8, p11); //Definition of LCD & Pins.

Timer sonar; //definition of the sonar timer.

PwmOut spker (p26); //Definition of the speaker.

PwmOut r (p23); //Definition of the red led.
PwmOut g (p24); //Definition of the green led.
PwmOut b (p25); //Definition of the blue led.

InterruptIn button(p14); //interrupt used to turn on/off buzzer. "calls function to flip buzzstart".
Timer debounce; //debounces button timer.

int measurement; //defines the measurement variable.

int offset = 0; //definition of the sonar timer offset.

float inMin = 200; //minimum value readable in mm.
float inMax = 4000; //maximum readable value in mm.
float outMin = 0; //minimum mapped output value.
float outMax = 1; //maximum mapped output value.
float mapping = 0; //mapping value.

bool buzzstart; // value flipped from o-1 to turn on off buzzer.

float spkerVal=0.5; //initial pwm out value.

//ranges used for buzzer.
int range1Min = 300;
int range2Min = 800;
int range3Min = 1200;

//ranges used for speaker output.
int spkroutnear= 1000;
int spkroutmid= 600;
int spkroutfar= 200;

float mapped_led() //function to create the map value for the leds.
{
    //mapping calculation for the measured distance to a float value between 0 and 1 used for RGB colour gradient shifts colour from green to red as the distance changes. I could have done this more directly but the mapping calculation is a nice bit of code to have to map one range of values to another.
    mapping = ((measurement - inMin) * (outMax - outMin) / (inMax - inMin) +  outMin);
//Caps the value for the RGBs between 0 and 1
    if (mapping < 0.00f) { //if statement less than 0 return 0.
        return 0;
    } else if (mapping > 1.00f) { //if statement greater than 1 return 1.
        return 1;
    } else {
        return mapping; //value to return between 0 and 1.
    }
}

void ledCntrl() //function to control the leds pwm value on the application board.
{
    r=mapped_led(); //sets the value of the common anode RGB red to a duty cycle equal to the mapped value.
    g=1-mapped_led (); //sets the value of the common anode RGB green to a duty cycle of 1 less the mapped value.

    if  (buzzstart==1) { //condition based on bool value used to set the on condition of the onboard speaker.
        if (measurement <= range1Min) { //if the measurement from the sensor is less than or equal to the lower value then;
            spker.period(1.0/spkroutnear); //creates the Pwm  out for the speaker/frequency to make the sound.
            spker=spkerVal; // this is the value for the speaker duty cycle output 0 would turn the speaker off.
        }
        if (measurement >= range1Min && measurement <= range2Min) { //condition if measurement is less than/equal to  range 1 and less than/equal to range 2 do the following;
            spker.period(1.0/spkroutmid); //creates the Pwm  out for the speaker/frequency to make the sound.
            spker=spkerVal; // this is the value for the speaker duty cycle output 0 would turn the speaker off.
        }
        if (measurement >= range2Min && measurement <= range3Min) { //condition if measurement is greater than/equal to  range 2 and less than/equal to range 3 do the following;
            spker.period(1.0/spkroutfar); //creates the Pwm  out for the speaker/frequency to make the sound.
            spker=spkerVal; // this is the value for the speaker duty cycle output 0 would turn the speaker off.
        } else if (measurement > range3Min) {//condition if measurement is greater than range 3 do the following;
            spker = 0; //turns off the speaker.
        }
    } else if (measurement > range3Min) { //condition if measurement is greater than range 3 do the following;
        spker = 0; //turns off the speaker.
    }
}
void buzzCntrl() //function to control the bool value used to activate the buzzer.
{
    if (debounce.read_ms() >(200)) { //this conditional statement checks to see if the debounce time is greater than x milliseconds. It ignores any detected presses inside of this time.
        debounce.reset(); //this will reset the button press timer allowing for another press to happen and the debouncing timer to start again.
        led4=!led4; //flips the condition of led 4.
        buzzstart = led4.read(); // links the state of buzzstart to led 4.
    }
}
void printdim()   //LCD Print Function
{
    lcd.cls(); //Clears the LCD
    lcd.locate(2,15); //Location to be used for measurement information in mm.
    lcd.printf("Measurement %d mm" ,measurement); //send the measurement to the lcd for display.
}
void measure_offset () //allows for the measure of software polling timer delay in microseconds used to correct possible errors in the measurement times due to the delay.
{
    while (echo==2) {}; // loops while the value of echo is 2, then following happens.
    led2 = 0; // condition of led 2 is set to 0.
    sonar.stop(); // the timer sonar is stopped.
    offset = sonar.read_us(); // reads the timer
}
void take_measure()   //measure distance between 2cm and 4m.
{
    int A_sum = 0; //sets the initial value for the average sum of the readings.

    while(1) { //Loop to read Sonar distance values, scale, and print values.
        trig = 1; // trigger sonar to send a ping
        led1 = trig; // led1 was set to trigger
        led2 = 0; // led 2 was set to 0
        sonar.reset(); //the sonar timer was reset.
        wait_us(10.0); // wait period for trigger out signal.
        trig = 0;  // turns of the trigger signal
        led1 = trig; //sets the led1 to the value of the trigger.
//wait for echo high
        while (echo==0) {}; // loop while the echo = o, then do the following.
        led2=echo; // sets led 2 equal to the state of echo.
        sonar.start(); //echo high, so start timer
        while (echo==1) {}; //loop while echo = 1, then do the following;
        sonar.stop(); //stop timer
        for (int A = 0; A < 5; ++A) { //for the increments of I, read the sonar and sum the values, each reading has the software overhead timer delay subtracted and is scaled to mm
            A_sum += (((sonar.read_us()-offset)/58.0)*10); //value of the sum.
        }
        measurement = A_sum/5.00f; //average of the readings by dividing the sum by the number of reading “5”.
        led2 = 0; //sets the value of the led to 0.
        wait(0.2); //loop wait period.
        break; // breaks out of the loop.
    }
}
int main() //main function of the application.
{
    r=1; //initial value of the red led.
    g=1; //initial value of the red green.
    b=1; //initial value of the blue led.
    sonar.reset();// resets the value of the sonar.
    sonar.start(); //starts the sonar timer.
    measure_offset(); //calls the measure offset value.
    button.rise(&buzzCntrl); //interrupt in call the buzzer control function.
    debounce.start(); //starts the button debounce timer.

    while(1) { // main while loop.
        take_measure(); //calls the measure function.
        mapped_led(); // calls the value mapping function for the leds.
        printdim(); //calls the print function to print the dimensions out the to the led screen.
        ledCntrl(); // calls the led control function.
    }
}


