#include "mbed.h" // includes libraries for the mBed.
#include "C12832.h" // includes libraries for the mBed LCD Display.
// 2.5 Debounce Switch Experiment
// This is to show the effect of the introduction of an interrupt. the interrupt will be triggered using a button on the mbed and will set check to see if a variable has been set. if not it will set it.

C12832 lcd(p5, p7, p6, p8, p11);   // declaration of the On board LCD display
DigitalOut led1(LED1); // declaration for the Digital output to LED 1
DigitalOut flash (LED4); // declaration for the Digital output to LED 1
InterruptIn button(p14); // declaration for the interrupt In button using Pin 14 which is the middle button on the joystick.

int Var_val = 0; //This is setting the value of the Variable value required to a known value.
int Counter = 0; //This is setting the value of the Variable value required to a known value, I have chosen to set the number of counts of the button presses to the LCD Screen.
Timer debounce; // declares the timer class debounce, the debounce is used to prevent false signals (false positives when a button is pressed) as interactions on the board are so fast the action of pressing the button is slow by comparison and may result in several button press detections.

void flip() //This function is activated by the button and flips the value of button press.
{
    if (debounce.read_ms() >(500)) { //this conditional statement checks to see if the debounce time is greater than 500milliseconds. It ignores any detected presses inside of this time.
        debounce.reset(); //this will reset the button press timer allowing for another press to happen and the debouncing timer to start again.
        Var_val=1; // this resets the required variable value to logic 1
        led1=!led1; // this toggles the led as it takes the value of Led1 and sets it to not Led1, when pressing the button this connects the 3.3v to the pin p14.
    }
}
void printout() {//This function will print the values to the LCD.
    if (Var_val==1) { //This is a conditional if statement. If the variable in the brackets equals 1 then it runs the print out code.
    lcd.cls(); // clears the LCD.
    lcd.locate(0,0); // sets the location on the LCD that will be used later.
    lcd.printf("Variable Set & will Reset \n Count %d", Counter++); // uses the printf function to print the defined text and the placeholder for the integer (Counter++) which I am using to print out the count value of the number of flips.
} //closes out the if condition.
}
int main() // this is the main function in the code.
{
    button.rise(&flip); //attach the function address to the rising edge of the button on pin p14, this value will then be flipped (change in logic state).
    debounce.start(); //This starts the debounce timer, and will make the if statement above ignore subsequent signals until the debounce time has been met.
    Counter = 1; //This is the initial counter state used to print out the button presses.

    while(1) { // This is the while loop, while 1 is infinite, the interrupt will run inside this. the interrupt will be used to reset the variable value and print the count value of the button presses.
        flash = !flash; // this turns led4 on and off every 1/4 of a second.
        printout(); //runs the print to lcd function- Keeping the printout outside of the flip allows the test of the variable to be conducted as part of the conditional statement. 
         Var_val = 0; //resets the value of the variable to 0.
        wait (.25); //wait period for the loop.
    } //closes out the while 1 loop
} //closes out the main.
