#include "mbed.h"
#include "as5048spi.h"

#define rayon_roue 0.0045
#define pi 3.14159

#define intervalle 0.005

As5048Spi sensor(PB_15, PB_14, PB_13, PB_12);   //MOSI, MISO, SCKL, CS
Serial pc(USBTX, USBRX); // tx, rx
InterruptIn bouton(PC_13);
Ticker timer;
int angle, degrees_avant, degrees_maintenant, degrees_vitesse;
float vitesse;

void donnee_saisie()
{
    const int* angles = sensor.read_angle();
    angle = angles[0];
    //Récupération de l'angle précédent
    degrees_avant = degrees_maintenant;
        
    //Aquisition du nouvel angle
    degrees_maintenant = sensor.degrees(angle)/100;
        
    //Calcul de la différence
    degrees_vitesse = (degrees_maintenant - degrees_avant) / intervalle;
        
    vitesse = (rayon_roue * degrees_vitesse * 2 * pi / 360) /*/ (5 + 0.01 / (2 * pi))*/;
}

void print_speed()
{
    timer.detach();
    //Affichage du résultat
    pc.printf("rotation = %d degrees/s, vitesse = %.4f mm/s     \r", degrees_vitesse, vitesse * 1000);
    timer.attach(&donnee_saisie, intervalle); //Lancement de la fonction "donnee_saisie()" toutes les 1 sec
}

int main() {
    bouton.rise(&print_speed);
    timer.attach(&donnee_saisie, intervalle); //Lancement de la fonction "donnee_saisie()" toutes les 1 sec
    while(1) 
    {
        
    }
}