/* UniPWM PWM Library
 * Copyright (c) 2012 Matt Parsons
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 #include "mbed.h"
 #include "UniPWM.h"
 
    UniPWM::UniPWM(PinName pin) : PWMPin(pin){
        Period=16667;
        PWMMin=100;
        PWMDuty=0;      //Default to Off
        PWMStatus=0;    //All ints are all off.
        PWMPin=0;       //Outputs are off
        PWMMax=Period;
    
      //Pulse.attach_us(this,&UniPWM::SigStart,PWMDuty);    //no longer needed as the PWM defaults to off
     }
 
    void UniPWM::SigStart(){
        PWMPin=1;
        PulseEnd.attach_us(this,&UniPWM::SigStop,PWMDuty);   
     }
 
    void UniPWM::SigStop(){
        PWMPin=0;
     }
 
    void UniPWM::write_us(int PosIn){
        PWMDuty=PosIn;
        
        if(PWMStatus==0){
        
            if(PosIn>PWMMin){
               PWMStatus=1;
               Pulse.attach_us(this,&UniPWM::SigStart,Period);
            }
        }else if(PosIn <= PWMMin){
            PWMStatus=0;
            PosIn=0;
            Pulse.detach();
        }
        
        
        if(PosIn>PWMMax){PWMDuty=PWMMax;}
     }
     
     void UniPWM::duty(float dutIn){
        dutIn=Period*dutIn;
        int pos=(int)dutIn;
        write_us(pos);
     }
     
     int UniPWM::read_us(){
        return PWMDuty;
     }
        
 
 