/*****************************************************************************
** @brief controlling                                                       **  
** @detail                                                                  **
** @argument: ipwd: pwd class                                               **
*****************************************************************************/  

#include "mbed.h"
#include "LEDFunctions.h"
#include "UniPWM.h" 
//#include "rtos.h"

//Serial pc(USBTX,USBRX);
 
LEDFunctions::LEDFunctions() 
{
    m_pwm.push_back(new UniPWM(p5));
    m_pwm[0]->duty(0);
    m_map.insert(std::pair<std::string, int>("p5", 0));
    m_pwm.push_back(new UniPWM(p6));
    m_pwm[1]->duty(0);
    m_map.insert(std::pair<std::string, int>("p6", 1));
    m_pwm.push_back(new UniPWM(p7));
    m_pwm[2]->duty(0);
    m_map.insert(std::pair<std::string, int>("p7", 2));
    m_pwm.push_back(new UniPWM(p8));
    m_pwm[3]->duty(0);
    m_map.insert(std::pair<std::string, int>("p8", 3));
    m_pwm.push_back(new UniPWM(p9));
    m_pwm[4]->duty(0);
    m_map.insert(std::pair<std::string, int>("p9", 4));
    m_pwm.push_back(new UniPWM(p10));
    m_pwm[5]->duty(0);
    m_map.insert(std::pair<std::string, int>("p10", 5));
    m_pwm.push_back(new UniPWM(p11));
    m_pwm[6]->duty(0);
    m_map.insert(std::pair<std::string, int>("p11", 6));
    m_pwm.push_back(new UniPWM(p12));
    m_pwm[7]->duty(0);
    m_map.insert(std::pair<std::string, int>("p12", 7));
    m_pwm.push_back(new UniPWM(p13));
    m_pwm[8]->duty(0);
    m_map.insert(std::pair<std::string, int>("p13", 8));
    m_pwm.push_back(new UniPWM(p14));
    m_pwm[9]->duty(0);
    m_map.insert(std::pair<std::string, int>("p14", 9));
    m_pwm.push_back(new UniPWM(p15)); // UniPWM(p15)
    m_pwm[10]->duty(0);
    m_map.insert(std::pair<std::string, int>("p15", 10));
    m_pwm.push_back(new UniPWM(p16));
    m_pwm[11]->duty(0);
    m_map.insert(std::pair<std::string, int>("p16", 11));
    m_pwm.push_back(new UniPWM(p17));
    m_pwm[12]->duty(0);
    m_map.insert(std::pair<std::string, int>("p17", 12));
    m_pwm.push_back(new UniPWM(p18));
    m_pwm[13]->duty(0);
    m_map.insert(std::pair<std::string, int>("p18", 13));
    m_pwm.push_back(new UniPWM(p19));
    m_pwm[14]->duty(0);
    m_map.insert(std::pair<std::string, int>("p19", 14));
    m_pwm.push_back(new UniPWM(p20));
    m_pwm[15]->duty(0);
    m_map.insert(std::pair<std::string, int>("p20", 15));
    m_pwm.push_back(new UniPWM(p21));
    m_pwm[16]->duty(0);
    m_map.insert(std::pair<std::string, int>("p21", 16));
    m_pwm.push_back(new UniPWM(p22));
    m_pwm[17]->duty(0);
    m_map.insert(std::pair<std::string, int>("p22", 17));
    m_pwm.push_back(new UniPWM(p23));
    m_pwm[18]->duty(0);
    m_map.insert(std::pair<std::string, int>("p23", 18));
    m_pwm.push_back(new UniPWM(p24));
    m_pwm[19]->duty(0);
    m_map.insert(std::pair<std::string, int>("p24", 19));
    m_pwm.push_back(new UniPWM(p25));
    m_pwm[20]->duty(0);
    m_map.insert(std::pair<std::string, int>("p25", 20));
    m_pwm.push_back(new UniPWM(p26));
    m_pwm[21]->duty(0);
    m_map.insert(std::pair<std::string, int>("p26", 21));
    m_pwm.push_back(new UniPWM(p27));
    m_pwm[22]->duty(0);
    m_map.insert(std::pair<std::string, int>("p27", 22));
    m_pwm.push_back(new UniPWM(p28));
    m_pwm[23]->duty(0);
    m_map.insert(std::pair<std::string, int>("p28", 23));
    m_pwm.push_back(new UniPWM(p29));
    m_pwm[24]->duty(0);
    m_map.insert(std::pair<std::string, int>("p29", 24));
    m_pwm.push_back(new UniPWM(p30));
    m_pwm[25]->duty(0);
    m_map.insert(std::pair<std::string, int>("p30", 25));
    m_pwm.push_back(new UniPWM(LED1));
    m_pwm[26]->duty(0);
    m_map.insert(std::pair<std::string, int>("LED1", 26));
    m_pwm.push_back(new UniPWM(LED2));
    m_pwm[27]->duty(0);
    m_map.insert(std::pair<std::string, int>("LED2", 27));
    m_pwm.push_back(new UniPWM(LED3));
    m_pwm[28]->duty(0);
    m_map.insert(std::pair<std::string, int>("LED3", 28));
    m_pwm.push_back(new UniPWM(LED4));
    m_pwm[29]->duty(0);
    m_map.insert(std::pair<std::string, int>("LED4", 29));
}

void LEDFunctions::on(int n, int d, float b, float s){
    if(s > 1){
        for(float k = b/s; k < b; k += b/s){
            p += b/s;
            m_pwm[n]->duty(p);
            //Thread::wait(100);
            wait(0.1);
        }
        for(float i = s*0.1; i < d; i += 0.1){
            m_pwm[n]->duty(b);
            //Thread::wait(100);
            wait(0.1);
        }
    }
    else{ 
        for(float i = 0; i < d; i += 1){
            m_pwm[n]->duty(b);
            //Thread::wait(1000);
            wait(1);
        }
    }
    m_pwm[n]->duty(0);
}

/*
void LEDFunctions::on_abst(int n, int starttime, int endtime, float b, float s){
    id(n);
    if(time==starttime){
        if(s > 1){
            for(k = 0; k = b; k = b/s){
                p = p + b/s;
                _pin.duty(p);
                wait(0.1);
            }
            for(i = starttime + b; i < endtime; i += 0.1){
                _pin.duty(b);
                wait(0.1);    
            }
        }
        else{ 
            for(i = starttime; i = endtime; i += 0.1){
                _pin.duty(b);
                wait(0.1);
            }
        }
    }
}
*/
void LEDFunctions::on_forever(int n, float b, float s){
    if(s > 1){
        for(float k = b/s; k < b; k += b/s){
            p += b/s;
            m_pwm[n]->duty(p);
            //Thread::wait(100);
            wait(0.1);
        }
    }
    else{ 
        m_pwm[n]->duty(b);
    }
}

void LEDFunctions::off_forever(int n, float b, float s){
    if(s > 1){
        for(float k = 1; k > b; k -= 1/s){
            p = k;
            m_pwm[n]->duty(p);
            //Thread::wait(100);
            wait(0.1);
        }
        m_pwm[n]->duty(b);
    }
    else{ 
        m_pwm[n]->duty(b);
    }
}

void LEDFunctions::blink(int n, int f, int d, float lb, float ub, float s){
    float time = 1.0 / (2.0*f);
    float inc = 1.0/f;
    for(float i = 0.0; i < d; i += inc){
        if(s > 1){
            for(float k = lb; k < ub; k += (ub-lb)/s){
                    p += (ub-lb)/s;
                    m_pwm[n]->duty(p);
                    //Thread::wait(time*1000/s)
                    wait(time/s);       
            }
            for(float k = ub; k > lb; k -= (ub-lb)/s){
                    p = k;
                    m_pwm[n]->duty(k);
                    //Thread::wait(time*1000/s);
                    wait(time/s);
            }
            m_pwm[n]->duty(lb);
            //Thread::wait(time*1000/s);
            wait(time/s);
        }
        else {
            m_pwm[n]->duty(ub);
            //Thread::wait(time*1000);
            wait(1);
            m_pwm[n]->duty(lb);
            //Thread::wait(time*1000);
            wait(1);
        }
    }
}
/*
void LEDFunctions::blink_abst(int n, int f, int startime, int endtime, float ub, float lb, float s){
    id(n);
    for(i = starttime; i = endtime; i += 1/frequency){
        if(s > 1){
            for(k = lb; k = ub; k += (ub-lb)/s){
                    lb = lb + (up-lb)/s;
                    _pin.duty(lb);
                    wait((1/2*f)/((ub-lb)/s));
            }
            for(k = ub; k = lb; k -= ub/s){
                    ub = ub - (ub-lb)/s;
                    _pin.duty(ub);
                    wait((1/2*f)/((ub-lb)/s));
            }
        }
        else{
            _pin.duty(ub);
            wait(1/2*f);
            _pin.duty(lb);
            wait(1/2*f);
        }
    }
}
*/