#include "LEDFunction.h"
#include "mbed.h"

LEDFunction::LEDFunction(PinName pin): _pin(pin){
    _pin=0;
    Period=16667;
    PWMMin=0;
    PWMDuty=Period/2;
    PWMMax=Period;
    Pulse.attach_us(this,&LEDFunction::SigStart,PWMDuty);
}

void LEDFunction::SigStart(){
    _pin=1;
    PulseEnd.attach_us(this,&LEDFunction::SigStop,PWMDuty);   
}
 
void LEDFunction::SigStop(){
    _pin=0;
}

void LEDFunction::write_us(int PosIn){
    PWMDuty=PosIn;
    if(PosIn<PWMMin){PWMDuty=PWMMin;}
    if(PosIn>PWMMax){PWMDuty=PWMMax;}
}

void LEDFunction::duty(float dutIn){
    dutIn=Period*dutIn;
    int pos=(int)dutIn;
    write_us(pos);
}
     
int LEDFunction::read_us(){
    return PWMDuty;
}
    
void LEDFunction::OnOff(){
    if(_pin=0){_pin=1;}
    else _pin=0;
}
    
void LEDFunction::flash(int n){
    for(i=0;i<2*n;i++){
        _pin=!_pin;
        wait(0.5);
    }
}