#include "mbed.h"
#include <string>

#include <Adafruit_GFX.h>
#include <TFT_ILI9163C.h>
#define __MOSI D11
#define __MISO NC
#define __SCLK D13
#define __CS D10
#define __DC D15
#define __RST D12

// Color definitions
#define BLACK           0x0000
#define BLUE            0x001F
#define RED             0xF800
#define GREEN           0x07E0
#define CYAN            0x07FF
#define MAGENTA         0xF81F
#define YELLOW          0xFFE0
#define WHITE           0xFFFF
#define TRANSPARENT     -1
/******************************************************state machine decleration**********/
#define initial 1
#define pair 2
#define checkpin 3
#define disconnected 4
//******************************************************************************************//
#define SPI_BITRATE     50000000L
 int color[8] = {0x001F, 0xF800,0x07E0,0x07FF,0xF81F,0xFFE0,0xFFFF,0x001F};
TFT_ILI9163C tft(__MOSI, __MISO, __SCLK, __CS, __DC, __RST);

Serial blue(D1,D0); 
//*****************************************function declerations************************/
void intial_screen(void);
void connectedBlue(void);
void disconnectedBlue(void);
bool passwordType(void);
void CorrectPassword(void);
void Incorrect(void);
/***************************************************************************************/
char blueInput;
char passwordGlobal[3];
unsigned char stage = initial;
int look =1;
int check =0;
int main()
{   
    tft.begin();
    tft.setBitrate(50000000);
    tft.setRotation(0);
   blueInput =  '\0';
    blue.printf("*P*            ");
    while (true) {
                                 
                
      
      switch(stage){
        
          case initial : if(look^check) // prints only ones a time in for loop by xOR 
                                        {
                            intial_screen();
                            check = 1;
                                        }
                        
                            
                                
                                 if (blueInput=='F')  
                                 {
                                
                                    stage = disconnected;
                                    check = 0;
                                       }  
                          
                            if(blueInput == 'N'){
                                 
                                 if(look^check){
                                    connectedBlue();
                                    check =1;
                                                }
                                 stage = pair;
                                 check = 0;     
                                            }
                             blueInput = blue.getc(); // waits for input char
                            
          
          case pair :               if(look^check){
                                    connectedBlue();
                                    check =1;
                                                }
                                    stage = checkpin;
                                    check =0;
                                     
       
         case checkpin:     if(passwordType()) {
                                if(look^check){
                                CorrectPassword();
                                check=1;
                                    }
                               stage = initial; 
                               check =0;
                                }
                            else{
                                if(look^check){
                                Incorrect();
                                check=1;
                                    }
                               stage = initial; 
                               check =0;}
           
          
           case    disconnected :        if(look^check){
                                  disconnectedBlue();
                                  check = 1;
                                }   
                                 
                                  stage  = initial; 
                                  check = 0;           
          
          }//switch
    }//forloop
}//main

void intial_screen(void){
 
  
    tft.clearScreen();
    tft.fillScreen(BLACK);
    tft.setTextColor(GREEN);
    tft.setTextSize(2);
    tft.setCursor(1, 1);
    tft.printf("Bluetooth");
    tft.setCursor(1,30);
    tft.printf("Pairing");
    tft.setCursor(1,60);
    tft.printf("Required");
    
    
    }

void connectedBlue(void){
                    tft.clearScreen();
                    tft.fillScreen(BLACK);
                     tft.setTextColor(GREEN);
                     tft.setTextSize(2);
                     tft.setCursor(1, 1);
                     tft.printf("connected");
                     tft.setCursor(1,30);
                     tft.printf("Type");
                     tft.setCursor(1,60);
                     tft.printf("Password");
    
    }
    
void disconnectedBlue(void){
                     tft.clearScreen();
                     blue.printf("*P*            ");
                     tft.fillScreen(BLACK);
                     tft.setTextColor(GREEN);
                     tft.setTextSize(2);
                     tft.setCursor(1,1);
                     tft.printf("Connection");
                     tft.setCursor(1,30);
                     tft.printf("Lost");
                    
                     wait_ms(2000);
                    
}

bool passwordType(void){
    int i = 0;
    char password[3];
    int b =32;
    string c;
    blue.printf("*P*            ");
  
          
       
      
   
  for(i=0;i<3;i++){
        password[i] = blue.getc();
        if (blueInput=='F')  
                                 {
                                
        stage = disconnected;
         check = 0;
                                   }  
        tft.setCursor(b,90);
        tft.printf("*");
        c = password;
        blue.printf("*P%s*",c);
        b+=20;
        } 
        
        if(c == "123") return 1;
        
        else return 0; 
      
    }//function
    
    
    void CorrectPassword(void){
                     tft.clearScreen();
                     tft.setCursor(1, 1);
                     tft.printf("Correct");
                     tft.setCursor(1,30);
                     tft.printf("Password");
                     tft.setCursor(1,60);
                     tft.printf("Door");
                     tft.setCursor(1,90);
                     tft.printf("Open 5 sec");
                     wait_ms(5000);
           
        
        }
        
    void Incorrect(void){
                 tft.clearScreen();
                   tft.setCursor(1, 1);
                     tft.printf("Wrong");
                     tft.setCursor(1,30);
                     tft.printf("Password");
                     tft.setCursor(1,60);
                     wait_ms(2000);
    
        }