/*
                  TPJ project 
Automated Solar Power Harvesting System 

It is created  by Ozan SANCI

Description: This program controls charging operation of SLA battery(6V-4A) with 12V 2W Solar Panel and  controls:

    -load On/OFF
    -ADC real-time voltage on both solar and battery,
    -power consumption with ACS712 Current Sensor (-5 to 5A)
    -interfacing with user via Nokia 5110 screen as well as HC-05 Bluetooth module. 
    -third part Android application, “Bluetooth Electronic” is used. 

Additional note: The charging algorithms for the final demonstration have been changed slightly: 
    Solar Panel and battery voltage thresholds, 6.5V, and 6.4V are changed to 6V. 
    Because, instead of solar panel, A dc source is used since solar panel is not able to provide enough power in the Lab.  

*/

#include"mbed.h"
#include "Terminal.h"
#include "N5110.h"
#include "string"

/*********************************Pin decleration*************/
Serial pc(USBTX, USBRX);
Serial blue(PTC15,PTC14); 
AnalogIn solar_voltage(A0);
AnalogIn battery_voltage(A1);
AnalogIn load_current(A2);
DigitalOut solar_gate(D5);
DigitalOut load_gate(D4);
DigitalIn  pushBtnLeft(D3);
DigitalIn  pushBtnRight(D2);
DigitalOut blueLed(D0);
/*******************************************************************/
using std::string;
/****************************Nokia5110 Pin Decleration*********/
 //SCE,RST,D/C,MOSI,SCLK,LED
N5110 lcd(PTA0,PTC2,PTC4,PTD2,PTD1,PTC3);
/*****************************************************************/      
#define solargate 
#define refVolt 3300
float solarVoltage;
unsigned char sGate = 'A'; //Initially gate is open
unsigned char bGate = 'B';//Initially gate is open

 string gateStat= "LR255G0B0"; // INTIALLY IT IS RED, GREEN IS LR0G255B0
float batteryVoltage;
/********************************************************Function Prototypes************/

float fnc_solarPanel(void);
bool fnc_chargingstat(float i);
float fnc_batteryVolt(void);
bool fnc_loadstat(float i);
float fnc_load_current(void);

/************************************************************M A I N************************/
int main(){
bool loadStatus, chargingStatus,screenOne,screenTwo;
 solarVoltage = 0.0;
 batteryVoltage = 0.0;
float loadCurrent = 0.0;
float usagePower = 0.0;
float powerLeftinW = 0.0;
int powerLeftinH = 0.0;
char outputs[10];//it is used for conversion from solar volt (float) to char in order to print as string. 
char outputb[10];//it is used for conversion from battery charge(float) to char in order to print as string.
char outputc[10];//it is used for conversion from current charge(float) to char in order to print as string. 
char blueInput;
int left, right;
lcd.init();
lcd.normalMode();
lcd.setBrightness(1.0); 

loadStatus  = false;
chargingStatus = false;
screenOne = true;
screenTwo = false;
right = 1;
left = 0;
blueLed = 0;
    while(1){
       
       if (blue.readable()) {
            blueLed = 1;
           
            blueInput = blue.getc();
           switch(blueInput){
               case 'B' : bGate = 'B'; break;
               case 'b' : bGate = 'b'; break;
               case 'A': sGate = 'A';break;
               case 'a' : sGate = 'a'; break;
               
               }}
        

            
        
        
        
right = pushBtnRight.read();
left = pushBtnLeft.read();
if(right){screenOne = false; screenTwo = true; }
if(left){screenOne=true;screenTwo=false;}
if(screenOne)
{


lcd.clear();
solarVoltage=fnc_solarPanel();//solar voltge 
            sprintf(outputs,"SolarV: %.2fV",solarVoltage); 
            lcd.printString(outputs,0,0);
    //lcd.refresh();
    blue.printf("*S%s*",outputs);
   

chargingStatus = fnc_chargingstat(solarVoltage); // return true if volt bigger than 6V else false and sets the gate
    if (chargingStatus){lcd.printString("Charging: ON ",0,1);/*lcd.refresh();*/blue.printf("*LR0G255B0*");}
        else {lcd.printString("Charging: OFF",0,1);blue.printf("*LR255G0B0*");}
     /*lcd.refresh();*/
batteryVoltage = fnc_batteryVolt(); // return battery volt as float
            sprintf(outputb,"Battery: %.2fV",batteryVoltage); /*lcd.refresh();*/
            lcd.printString(outputb,0,2);
  /*lcd.refresh();*/    
  blue.printf("*B%s*",outputb);  

loadStatus = fnc_loadstat(batteryVoltage); // return true if volt higger than 6v else fals end sets the gate
    if (loadStatus){lcd.printString("Status: ON  ",0,3);/*lcd.refresh();*/blue.printf("*MR0G255B0*");}
        else {lcd.printString("Status: OFF",0,3);blue.printf("*MR255G0B0*");}
/*lcd.refresh();*/
fnc_load_current(); // only return current as float and power calculations are required 
lcd.printString("Power Usage =>",0,5);
    lcd.refresh();
    fnc_load_current();
loadCurrent = fnc_load_current();
      sprintf(outputc,"Load:%.2fmA",loadCurrent); 
            
            blue.printf("*E%s*",outputc);
      usagePower = loadCurrent * batteryVoltage;
      
      sprintf(outputc,"L-Power:%.2fmW",usagePower); 
           
            blue.printf("*I%s*",outputc);
      powerLeftinW = 24 - usagePower;
      if(batteryVoltage <= 5) powerLeftinW=0.0;
      sprintf(outputc,"B-Power:%.1fkW",powerLeftinW);
      blue.printf("*I%s*",outputc);
            
       powerLeftinH = 24 / usagePower;
       if(batteryVoltage <= 5) powerLeftinH=0.0;
       sprintf(outputc,"B-Hour:%dh", powerLeftinH); 
           
            blue.printf("*N%s*",outputc);
       
    wait_ms(500);
    }//if screenone
    
    if(screenTwo)
    { 
    lcd.clear();
   
solarVoltage=fnc_solarPanel();//solar voltge 
            sprintf(outputs,"SolarV: %.2fV",solarVoltage); 
            
    blue.printf("*S%s*",outputs);
   

chargingStatus = fnc_chargingstat(solarVoltage); // return true if volt bigger than 6V else false and sets the gate
    if (chargingStatus){blue.printf("*LR0G255B0*");}
        else {blue.printf("*LR255G0B0*");}
    
batteryVoltage = fnc_batteryVolt(); // return battery volt as float
            sprintf(outputb,"Battery: %.2fV",batteryVoltage); 
         
      
  blue.printf("*B%s*",outputb);  

loadStatus = fnc_loadstat(batteryVoltage); // return true if volt higger than 6v else fals end sets the gate
    if (loadStatus){blue.printf("*MR0G255B0*");}
        else {blue.printf("*MR255G0B0*");}

fnc_load_current(); // only return current as float and power calculations are required 
//*******************************

      loadCurrent = fnc_load_current();
      sprintf(outputc,"Load:%.2fmA",loadCurrent); /*lcd.refresh();*/
            lcd.printString(outputc,0,0);/*lcd.refresh();*/
            blue.printf("*E%s*",outputc);
      usagePower = loadCurrent * batteryVoltage;
     
      sprintf(outputc,"L-Power:%.2fmW",usagePower); /*lcd.refresh();*/
            lcd.printString(outputc,0,1);/*lcd.refresh();*/
            blue.printf("*I%s*",outputc);
      powerLeftinW = 24 - usagePower;
       if(batteryVoltage <= 5) powerLeftinW=0.0;
      sprintf(outputc,"B-Power:%.1fkW",powerLeftinW); /*lcd.refresh();*/
      
      blue.printf("*I%s*",outputc);
        lcd.printString(outputc,0,2);/*lcd.refresh();*/
       powerLeftinH = 24 / usagePower;
        if(batteryVoltage <= 5) powerLeftinH=0.0;
       sprintf(outputc,"B-Hour:%dh", powerLeftinH); /*lcd.refresh();*/
            lcd.printString(outputc,0,3);/*lcd.refresh();*/
            blue.printf("*N%s*",outputc);
       lcd.printString("",0,1);/*lcd.refresh();*/
       lcd.printString("<= Charger",0,5);
       lcd.refresh();
     wait_ms(500);
        }// if screentwo

    }
 }
 /******************************************E N D   M A I N*************************/



 /******************************************Function Definations********************/
 
 float fnc_solarPanel(void)//Solar Panel Voltage at A0 in -------------------------------------------
 {
         float solarVolt = ((solar_voltage.read() * (refVolt/1000.0))*2.63);    
         return solarVolt;  
 }
   //-------------------------------------------------------------------------------------------------------------
     
     
 bool fnc_chargingstat(float i)//it returns true if voltage on solar panel is enough. 
 {
        if (i<6|| sGate =='a' ) 
        {
            solar_gate = 0; 
            gateStat = "LR255GOBO";
         //   blue.printf("*OR255G0B0*");
        
        return false;  
        }
        else {
          // blue.printf("*OR0G255B0*");

            gateStat= "LROG255BO";
         solar_gate = 1; return true;}
         
 }
      //------------------------------------------------------------------------------------------------------------
 float fnc_batteryVolt(void) //Returns battery volage as float
 {
        batteryVoltage = ((battery_voltage.read()*(refVolt/1000.0))*3.7789);
        return batteryVoltage;  
 }
       //--------------------------------------------------------------------------------------------------

 bool fnc_loadstat(float i)
 {  //bool stat; 
         
        if (i <6 ){ blue.printf("*OR255G0B0*");  return false;  }
        else{  blue.printf("*OR0G255B0*"); return true;} 
 
// return stat; 
 }
    
 //-----------------------------------------------------------------------------------------------------------------------
    float fnc_load_current(void)
 {                                                
       float loadcurrent = load_current.read();
       return loadcurrent; 
 }  
 
 //--------------------------------------------------------------------------------------------------
 