/*
This file contains the main function prototypes for the Buggy project
*/
#ifndef _BUGGY_H_
#define _BUGGY_H_

#include "MicroBit.h"

/*******************************************************************
Definition of global constants to control how to move the buggy
*******************************************************************/
#define MOVE_FORWARD            0
#define MOVE_BACKWARD           1
#define ROTATE_CLOCKWISE        2
#define ROTATE_ANTICLOCKWISE    3


/*This command should be called when we want to stop the buggy because of a
detected obstacle*/
void PauseLastCommand();
/*This command should be called once we are sure that the detected obstacle is
no longer present and the buggy will complete the last command it was executing
before it was paused*/
void ContinueLastCommand();
/*This command should be polled whilst the buggy is moving. It returns a true
when the last command has been completed and is also responsible for stopping the
buggy once the last command has been completed.  Without polling this command, 
the buggy will continue to run*/
bool hasLastCommandCompleted();
/*This command initialises the microbit runtime, sets up the buttons to receive events
and kicks off the sonar pulses.*/
void InitialiseBuggy();
/*This function returns the latest sonar timing in microseconds. The user needs
to convert this to a distance measure at some point*/
unsigned int GetSonarTime_us();
/*Test function to test the anti-collision function.  The buggy will run forward
at the input motor Voltage for a maximum of Time_ms, but will pause when it detects
that an obstacle is within a sonar echo of SonarTime_us microseconds.  This is here
as a tip for the user to know how to use the above functions.*/
void TestAntiCollision(unsigned int Voltage, unsigned int Time_ms, unsigned int SonarTime_us);
/*Test function to assist the user in relating a motor voltage to the speed that
the motor travels at. Pushing button A will toggle the test to different settings
for motor speed and direction. Pushing button B then starts the test after a
3, 2, 1 countdown.*/
void MotorSpeedCharacterisation(void);
/*Function to test the buggy after a build. The buggy will first use the LEDs
to display the sonar result for 10 secs, the drive forward, backwards, rotate
clockwise, then anti-clockwise*/
void SelfTest();
/*Function to print the sonar echo in ms using the LEDs and if connected to a PC,
also using the COMMS port (serial output). This can be used to characterise the
ultrasonic sensor*/
void DisplaySonarTiming();

//Export of the microbit runtime instance.
extern MicroBit uBit;



#endif


