#include "mbed.h"
#include "assert.h"

int SignExtend( int value, const int bit_width )
{
    assert( ( bit_width > 1) && ( bit_width < (8*sizeof(int)) ) );

    value &= ( (1<<(bit_width)) - 1 ); /* Clear out any extra MSB data */

    if ( ( value & ( 1 << (bit_width-1) ) ) != 0 )
    {
        /* value IS negative */
        value -= (1<<bit_width);
    }

    return value;
}
