#include "mbed.h"
#include "Telemetry.hpp"
#include "tsi_sensor.h"
#include "MMA8451Q.h"
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)

/*
    Example of the 'Telemetry' library, a portable communication library for embedded devices.
    
    This code fetches all the data from the KL25Z bord and publishes it on different topics :
    
    The available data is the following :
    * Accelerometer X
    * Accelerometer Y
    * Accelerometer Z
    * Capacitive slider
    
    You can use the Pytelemetry Command Line Interface to open plots, visualize the received data,
    and communicate with the car.
    See https://github.com/Overdrivr/pytelemetrycli
*/


DigitalOut led(LED1);

int main()
{   
    Telemetry TM(115200);

    // Some sensors to read
    TSIAnalogSlider tsi(PTB16,PTB17,40);
    MMA8451Q acc(PTE25, PTE24);
    
    led = 1;
    
    // Some timers
    Timer tm_timer;
    Timer print_timer;
    Timer led_timer;
    
    tm_timer.start();
    print_timer.start();
    led_timer.start();
    
    // To store accelerometer values
    int16_t axis[3];
    
    for(;;)
    {       
        // update telemetry
        if(tm_timer.read_ms() > 50)
        {
            tm_timer.reset();
            TM.update();   
        }
        
       
        // publish accelerometer data
        if(print_timer.read_ms() > 50)
        {
            print_timer.reset();
            TM.pub_f32("touch",tsi.readPercentage());
            
            acc.getAccAllAxis(axis);
            
            TM.pub_i16("acc/x",axis[0]);
            TM.pub_i16("acc/y",axis[1]);
            TM.pub_i16("acc/z",axis[2]);            
        }
        
        if(led_timer.read_ms() > 500)
        {
            led_timer.reset();
            led = (led == 0) ? 1 : 0;  
        }
    }
}