#include "mbed.h"
#include "Telemetry.hpp"

/*
    Example of the 'Telemetry' library, a portable communication library for embedded devices.
    
    This code shows how you can use the powerful topic adressing of the library
    to send complex, indexed and sparse data such as arrays, lists, etc. 
    
    You can use the Pytelemetry Command Line Interface to open plots, visualize the received data,
    and communicate with the car.
    See https://github.com/Overdrivr/pytelemetrycli
*/

int main()
{   
    Telemetry TM(115200);
    
    Timer refresh_timer;
    refresh_timer.start();
    
    // The topic under which the array is published
    char topic [] = "sin:000";
    
    // The sent array contains 16 elements
    // Each element takes the value of a sine function, with a phase difference between each element
    // In the command-line interface, the generated data will visualize as a moving sine wave
    
    // Time for simulating sine function
    float t = 0;
        
    for(;;)
    {
        // 10 times per second
        if(refresh_timer.read_ms() > 100)
        {
            refresh_timer.reset();
            
            // Compute a 16 points window on a sine function that shifts in time
            for(uint16_t i = 0 ; i < 16 ; i++)
            {
                // Compute sinus of point i
                float s = sin(2 * 3.14159 * t + i/10.0);
                
                // Build the topic
                // First topic will be 'sin:0'
                // Second topic will be 'sin:1', etc            
                sprintf(topic,"sin:%u",i);
                
                // Publish sine value at index 'i' to topic 'sin:i'
                TM.pub_f32(topic,s);
            }
            
            // Move time forward
            t += 0.005;
        }
    }
}