/*
Date    Jeu 24-aoû-2017 à 08:51 - il y a 4 minutes
Sujet   description du lab 1

Voici

    Vous devez concevoir et développer un système constitué d'un écran tactile et d'un détecteur d'objets à partir de l'information fournie en classe. Le système communiquera avec un pc par lien série.

    Il vous faudra d'abord:
        acquérir et analyse l'information technique d'intérêt
        décider d'une application
        établir l'architecture du matériel
        faire fonctionner chacune des parties séparément
        prendre les mesures nécessaires pour pouvoir établir un mode de partage du temps de calcul
        établir l'architecture du logiciel
        procéder à l'intégration

    Le code suivant pourra vous être utile: */

#include "mbed.h"

#define TFTWIDTH  240
#define TFTHEIGHT 320

#define TFT_NORTH {SPFD5408_MADCTL_MY | SPFD5408_MADCTL_BGR}
#define TFT_EAST  {SPFD5408_MADCTL_MX | SPFD5408_MADCTL_MY | SPFD5408_MADCTL_MV | SPFD5408_MADCTL_BGR}
#define TFT_SOUTH {SPFD5408_MADCTL_MX | SPFD5408_MADCTL_BGR}
#define TFT_WEST  {SPFD5408_MADCTL_MV | SPFD5408_MADCTL_BGR}

#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF

#define SPFD5408_SOFTRESET          0x01
#define SPFD5408_SLEEPIN            0x10
#define SPFD5408_SLEEPOUT           0x11
#define SPFD5408_NORMALDISP         0x13
#define SPFD5408_INVERTOFF          0x20
#define SPFD5408_INVERTON           0x21
#define SPFD5408_GAMMASET           0x26
#define SPFD5408_DISPLAYOFF         0x28
#define SPFD5408_DISPLAYON          0x29
#define SPFD5408_COLADDRSET         0x2A
#define SPFD5408_PAGEADDRSET        0x2B
#define SPFD5408_MEMORYWRITE        0x2C
#define SPFD5408_PIXELFORMAT        0x3A
#define SPFD5408_FRAMECONTROL       0xB1
#define SPFD5408_DISPLAYFUNC        0xB6
#define SPFD5408_ENTRYMODE          0xB7
#define SPFD5408_POWERCONTROL1      0xC0
#define SPFD5408_POWERCONTROL2      0xC1
#define SPFD5408_VCOMCONTROL1       0xC5
#define SPFD5408_VCOMCONTROL2       0xC7
#define SPFD5408_MEMCONTROL         0x36
#define SPFD5408_MADCTL             0x36
#define SPFD5408_MADCTL_MY          0x80
#define SPFD5408_MADCTL_MX          0x40
#define SPFD5408_MADCTL_MV          0x20
#define SPFD5408_MADCTL_ML          0x10
#define SPFD5408_MADCTL_RGB         0x00
#define SPFD5408_MADCTL_BGR         0x08
#define SPFD5408_MADCTL_MH          0x04

#define IDLE    1
#define ACTIVE  0
#define COMMAND 0
#define DATA    1

#define TEMPS   40

#define VERT_LINE 0
#define HORI_LINE 1

DigitalOut pinRD(A0);   //PA_0;
DigitalOut pinWR(A1);   //PA_1;
DigitalOut pinCD(A2);   //PA_4;
DigitalOut pinCS(A3);   //PB_0;
DigitalOut pinReset(A4);//PC_1;

BusInOut portTFT(D8, D9, D2, D3, D4, D5, D6, D7);

void WriteCommand(uint8_t c)
{
    pinCD = COMMAND;
    pinWR = ACTIVE;
    portTFT = c;
    pinWR = IDLE;
}

void WriteData(uint8_t d)
{
    pinCD = DATA;
    pinWR = ACTIVE;
    portTFT = d;
    pinWR = IDLE;
}

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(LED1);

 

void begin(void) {

    pinCS = IDLE;
    pinCD = DATA;
    pinWR = IDLE;
    pinRD = IDLE;
    portTFT.output();   

    pinReset = ACTIVE;
    pinReset = IDLE;

    pinCS = ACTIVE;
   
    WriteCommand(SPFD5408_SOFTRESET);
    WriteData(0);
    wait_ms(50);
   
    WriteCommand(SPFD5408_MEMCONTROL);
    WriteData(SPFD5408_MADCTL_MY | SPFD5408_MADCTL_BGR);
   
    WriteCommand(SPFD5408_PIXELFORMAT);
    WriteData(0x55);
 
    WriteCommand(SPFD5408_FRAMECONTROL);
    WriteData(0x00);
    WriteData(0x1B);
 
    WriteCommand(SPFD5408_SLEEPOUT);
    WriteData(0);
 
    WriteCommand(SPFD5408_DISPLAYON);
    WriteData(0);
}

void setAddrWindow(int x1, int y1, int x2, int y2) {
    pinCS = ACTIVE;
    wait_us(TEMPS);
    WriteCommand(SPFD5408_COLADDRSET);
    WriteData(x1 >> 8);
    WriteData(x1);
    WriteData(x2 >> 8);
    WriteData(x2);
    wait_us(TEMPS);
    pinCS = IDLE;

    pinCS = ACTIVE;
    wait_us(TEMPS);
    WriteCommand(SPFD5408_PAGEADDRSET);
    WriteData(y1 >> 8);
    WriteData(y1);
    WriteData(y2 >> 8);
    WriteData(y2);
    wait_us(TEMPS);
    pinCS = IDLE;
}

void fillRect(uint16_t x1, uint16_t y1, uint16_t w, uint16_t h, uint16_t fillcolor) {
    uint8_t hi, lo;
    uint16_t  x2, y2;
    uint16_t i, j;

    x2 = x1 + w - 1;
    y2 = y1 + h - 1;
    setAddrWindow(x1, y1, x2, y2);

    hi = fillcolor >> 8;
    lo = fillcolor;

    pinCS = ACTIVE;

    WriteCommand(SPFD5408_MEMORYWRITE);
    pinCD = DATA;
    
    for (i = h; i > 0; i--)
    {
        for (j = w; j > 0; j--)

        {
            pinWR = ACTIVE;
            portTFT = hi;
            pinWR = IDLE;
            pinWR = ACTIVE;
            portTFT = lo;
            pinWR = IDLE;            
        }
    }
    
    
    pinCS = IDLE;
}

void drawLine(uint8_t orientation,uint16_t x1, uint16_t y1, uint16_t lenght, uint16_t fillcolor) {
    uint8_t hi, lo;
    uint16_t  x2, y2;
    uint16_t i, j;
    
    if(orientation == VERT_LINE)
    {
        x2 = x1 - 1;
        y2 = y1 + lenght - 1;
    }
    else if(orientation == HORI_LINE)
    {
        x2 = x1 + lenght - 1;
        y2 = y1 - 1;
    }
    setAddrWindow(x1, y1, x2, y2);

    hi = fillcolor >> 8;
    lo = fillcolor;

    pinCS = ACTIVE;

    WriteCommand(SPFD5408_MEMORYWRITE);
    pinCD = DATA;
    
    for (i = lenght; i > 0; i--)
    {
        pinWR = ACTIVE;
        portTFT = hi;
        pinWR = IDLE;
        pinWR = ACTIVE;
        portTFT = lo;
        pinWR = IDLE;            
    
    }
    
    
    pinCS = IDLE;
}


void drawPixel(uint16_t x1, uint16_t y1, uint16_t fillcolor) {
    uint8_t hi, lo;
    uint16_t  x2, y2;
    
    x2 = x1 - 1;
    y2 = y1 - 1;
    
    setAddrWindow(x1, y1, x2, y2);

    hi = fillcolor >> 8;
    lo = fillcolor;

    pinCS = ACTIVE;

    WriteCommand(SPFD5408_MEMORYWRITE);
    pinCD = DATA;
    
 //   for (i = 1; i > 0; i--)
 //   {
        pinWR = ACTIVE;
        portTFT = hi;
        pinWR = IDLE;
        pinWR = ACTIVE;
        portTFT = lo;
        pinWR = IDLE;            
    
  //  }
    
    
    pinCS = IDLE;
}

int main()
{
    
    
    begin();
    drawLine(VERT_LINE,0, 20, 20, RED);
    //drawLine(HORI_LINE,30, 10, 20, RED);
    drawPixel(100,100,RED);
    //fillRect(75, 100, 100, 150, RED);
    //fillRect(80, 105, 90, 140, YELLOW);
    
    
    while(1)
    {
    }
}
