#include "mbed.h"
#include "rtos.h"
#include "TextLCD.h"
//<\>

DigitalOut  Fila1(PTD0,0);
DigitalOut  Fila2(PTD1,0);
DigitalOut  Fila3(PTD2,0);
DigitalOut  Fila4(PTD3,0);      
DigitalOut  led1(LED_GREEN,1);
DigitalOut  relay(PTA2,0);

InterruptIn Col1(PTC17);
InterruptIn Col2(PTB9);
InterruptIn Col3(PTA1);
InterruptIn Col4(PTB23);

TextLCD LCD(PTC2, PTC3, PTD0, PTD1, PTD2, PTD3); //rs, en, D4, D5, D6, D7

Thread *thread2;

char password[10] = "6A1C8B2C";
char caracter = ' ';

void Col1_press(void){
    thread2->signal_set(0x1);       
}

void Col2_press(void){
    thread2->signal_set(0x1);       
}

void Col3_press(void){
    thread2->signal_set(0x1);       
}

void Col4_press(void){
    thread2->signal_set(0x1);       
}

void leerTeclado(void const *argument)
{
    while (true)
    {
        Fila1 = 0;
        Fila2 = 1;
        Fila3 = 1;
        Fila4 = 1;
        if (Col1==0){ caracter = '1';
                        goto final;}
        if (Col2==0){ caracter = '2';
                        goto final;}  
        if (Col3==0){ caracter = '3';
                        goto final;}  
        if (Col4==0){ caracter = 'C';
                        goto final;}         
        Fila1 = 1;
        Fila2 = 0;
        Fila3 = 1;
        Fila4 = 1;      
        if (Col1==0){ caracter = '4';
                        goto final;}
        if (Col2==0){ caracter = '5';
                        goto final;}  
        if (Col3==0){ caracter = '6';
                        goto final;}  
        if (Col4==0){ caracter = 'D';
                        goto final;}  
        Fila1 = 1;
        Fila2 = 1;
        Fila3 = 0;
        Fila4 = 1;
        if (Col1==0){ caracter = '7';
                        goto final;}
        if (Col2==0){ caracter = '8';
                        goto final;}  
        if (Col3==0){ caracter = '9';
                        goto final;}  
        if (Col4==0){ caracter = 'E';
                        goto final;} 
         led1 = 0;
         wait(0.02);
         led1 = 1; 
        Fila1 = 1;
        Fila2 = 1;
        Fila3 = 1;
        Fila4 = 0;
        if (Col1==0){ caracter = 'A';
                        goto final;}
        if (Col2==0){ caracter = '0';
                        goto final;}  
        if (Col3==0){ caracter = 'B';
                        goto final;}  
        if (Col4==0){ caracter = 'F';
                        goto final;} 
 final:    Thread::wait(30);  
    }
}

void terminar(void const *argument){
    while (true){
        Thread::signal_wait(0x1);
        LCD.locate(11,0); 
        LCD.putc(caracter);  
        Thread::wait(30); 
    }                
}

int main()
{
    Thread tarea(leerTeclado);
    thread2 = new Thread(terminar);
    
    Col1.rise(&Col1_press);
    Col2.rise(&Col2_press);
    Col3.rise(&Col3_press);
    Col4.rise(&Col4_press);
    
    wait(0.25);
    LCD.cls();
    LCD.locate(0,0);
    LCD.printf(" Caracter: ");
    wait(0.25);
    
    while(true)
    {
        Thread::wait(300); 
        fflush(stdout);
        while (1){
            relay = !relay;
            wait(0.6);   
        }
    }
}