#include "mbed.h"
/*
DigitalOut gpo(D0);
DigitalOut led(LED_RED);
*/
//><
DigitalOut  BjtUnd(PTA2,1);
DigitalOut  BjtDcn(PTA1,1);

InterruptIn BtnInc(PTE25);
InterruptIn BtnDec(PTE24);

PortOut OutC(PortC,0x000000FF);
PortOut OutD(PortD,0x000000FF);

unsigned char unidades, decenas;

void ISR_Incrementar(){
    
    unidades ++;
    if (unidades == 10){
        unidades = 0;
        decenas ++;
        if (decenas == 10){
            decenas = 0;
        }
    }
    wait_ms(30);    
}

void ISR_Decrementar(){

    unidades --;
    if (unidades == 0xFF){
        unidades = 9;
        decenas --;
        if (decenas == 0xFF){
            decenas = 9;    
        }   
    } 
    wait_ms(30);  
}

void BinToDisplay(unsigned char num){
    switch (num){
        case 0: OutC.write(0);
                OutD.write(8);
                break;
        case 1: OutC.write(3);
                OutD.write(11);
                break;    
        case 2: OutC.write(4);
                OutD.write(2);
                break; 
        case 3: OutC.write(2);
                OutD.write(2);
                break; 
        case 4: OutC.write(3);
                OutD.write(1);
                break; 
        case 5: OutC.write(2);
                OutD.write(4);
                break; 
        case 6: OutC.write(0);
                OutD.write(5);
                break; 
        case 7: OutC.write(3);
                OutD.write(10);
                break; 
        case 8: OutC.write(0);
                OutD.write(0);
                break;
        case 9: OutC.write(3);
                OutD.write(0);
                break;  
    }   
}

int main()
{
    BtnInc.mode(PullUp);
    BtnDec.mode(PullUp);
    
    BtnInc.rise(&ISR_Incrementar);
    BtnDec.rise(&ISR_Decrementar);
    
    unidades = 0;
    decenas = 0;
    
    while (true) {
        
        BinToDisplay(unidades);
        BjtUnd = 0;
        BjtDcn = 1;
        wait(0.02);
        BinToDisplay(decenas);
        BjtUnd = 1;
        BjtDcn = 0;
        wait(0.02);
/*
        gpo = !gpo; // toggle pin
        led = !led; // toggle led
        wait(0.2f);
*/
    }
}