#include "mbed.h"
#include "TextLCD.h"

AnalogIn Canal1(A1); //PTB3
AnalogIn Canal0(A0); //PTB2

InterruptIn btn(PTA2);

DigitalOut led(LED_RED,1);
DigitalOut led2(LED_BLUE,1);

TextLCD LCD(PTC2, PTC3, PTD0, PTD1, PTD2, PTD3); //rs, en, D4, D5, D6, D7

bool sw = false;
float AdcFlt;

void ISR_Switch()
{
    sw = !sw;  
    LCD.cls();
    wait(0.25);     
}

int main()
{
    btn.mode(PullUp);
    btn.rise(&ISR_Switch);
    
    wait(0.25);
    LCD.cls();
    wait(0.25);
    
    while (true) 
    {
        if (sw == 0)
        {
            LCD.locate(0,0);
            LCD.printf("CH0 Valor: %5d",Canal0.read_u16());
            LCD.locate(0,1);
            LCD.printf("CH1 Valor: %5d",Canal1.read_u16());
            led = 0;
            wait(0.05);
            led = 1;
            wait(0.45);
        }
        else 
        {
            AdcFlt = Canal0.read_u16()*3.3/65536;
            LCD.locate(0,0);
            LCD.printf("CH0 Volts: %.3f",AdcFlt);
            AdcFlt = Canal1.read_u16()*3.3/65536;
            LCD.locate(0,1);
            LCD.printf("CH1 Volts: %.3f",AdcFlt);
            led2 = 0;
            wait(0.05);
            led2 = 1;
            wait(0.45);    
        }               
    }
}