#include "mbed.h"
#include "Keypad.h"
#include "TextLCD.h"
#include "rtos.h"
//<\>

AnalogIn Canal0(A0); //PTB2
AnalogIn Canal1(A1); //PTB3

DigitalOut   bjtUnd(PTB11,1);
DigitalOut   bjtDec(PTC11,1);
DigitalOut   led(LED_BLUE,1);
DigitalOut   led1(PTA2);
DigitalOut   led2(PTC4);

DigitalIn    btnInc(PTE25);
DigitalIn    btnDcr(PTE24);

EventQueue queue(32 * EVENTS_EVENT_SIZE);
EventQueue queue2(32 * EVENTS_EVENT_SIZE);

InterruptIn btn1(PTB10);

Keypad  kpad(PTD0,PTD1,PTD2,PTD3, PTC17,PTB9,PTA1,PTB23);

PortOut  OutC(PortC, 0x000103A3);

TextLCD LCD(PTC2, PTC3, PTD0, PTD1, PTD2, PTD3); //rs, en, D4, D5, D6, D7

Thread   th_btn1;
Thread   th_LCD;
Thread   th_Mux;

Ticker   tk_cuenta; 
Ticker   tk_blink;
Ticker   tk_LCD;

unsigned char unidades=0, decenas=0;
unsigned int val_display[10] = {0x80, 0x0102A2, 0x0120, 0x010020, 0x010202,
                                0x010001, 0x01, 0x0100A2, 0x00, 0x010000};
char key;
char user[7];
char mask[7];
char clave[] = "6D1#8A";
int released = 1;
int cnt1 = 0;
int i = 0;
int j = 0;
int CH0_Val;
int CH1_Val;
float CH0_Volt;
float CH1_Volt;

void Clear_Str(){
    for (i=0;i<=6;i++){ user[i] = '\0';}
    for (i=0;i<=6;i++){ mask[i] = '\0';}  
    i = 0; 
}

void LCD_Show(){
    switch (cnt1){
        case 0: LCD.locate(0,0);
                LCD.printf("CH0 Valor: %5d",CH0_Val);
                LCD.locate(0,1);
                LCD.printf("CH1 Valor: %5d",CH1_Val);
                break;
                    
        case 1: LCD.locate(0,0);
                LCD.printf("CH0 Volts: %.3f",CH0_Volt);
                LCD.locate(0,1);
                LCD.printf("CH1 Volts: %.3f",CH1_Volt);
                break;
                    
        case 2: LCD.locate(0,0);
                LCD.printf("   Led2 State:  ");
                LCD.locate(0,1);
                if (!led2){ LCD.printf("    SHUT OFF    ");}
                else { LCD.printf("    ACTIVATE    ");}
                break;
                
        case 3: LCD.locate(0,0);
                LCD.printf("    PASSWORD:   ");
                LCD.locate(0,1);
                LCD.printf("    ");
                LCD.locate(5,1);
                j = 0;
                while (mask[j]=='*'){
                    LCD.putc(mask[j]);
                    j ++;    
                }
                LCD.locate(11,1);
                LCD.printf("      ");
                break;
                
        case 4: if (strcmp(user,clave)==0){ 
                    LCD.locate(0,0);
                    LCD.printf("     PUERTA      ");
                    LCD.locate(0,1);
                    LCD.printf("     ABIERTA!    "); 
                    led1 = 1;
                    wait(2);
                    led1 = 0;
                }
                else { LCD.locate(0,0);
                       LCD.printf("     CLAVE      ");
                       LCD.locate(0,1);
                       LCD.printf("   INCORRECTA   ");
                       wait(2);
                }
                LCD.cls();
                Clear_Str();
                cnt1 = 0; 
                wait_ms(100);
                break;              
    }
}

void ISR_led2(){
    wait_ms(100);
    led2 = !led2;
}

void Blink_led(){
    led = !led;
}

void multiplexado_display()
{
    while(1){
        OutC.write(val_display[unidades]);
        bjtUnd = 0;
        bjtDec = 1;
        wait_ms(10);
        OutC.write(val_display[decenas]);
        bjtUnd = 1;
        bjtDec = 0;
        wait_ms(10);
    }       
}

void contador_up_down()
{
    if (!btnInc){
        unidades ++;
        if (unidades==10){
            unidades = 0;
            decenas ++;
            if (decenas==10){
                decenas = 0;
            }
        }
    }
    else { 
        if (!btnDcr){
            unidades --;
            if (unidades==0xFF){
                unidades = 9;
                decenas --;
                if (decenas==0xFF){
                    decenas = 9;
                }
            }
        }
    }
}

int main()
{   
    LCD.cls(); 

    th_LCD.start(callback(&queue, &EventQueue::dispatch_forever));
    tk_LCD.attach(queue.event(LCD_Show), 0.5);
    
    btn1.mode(PullUp);
    th_btn1.start(callback(&queue2, &EventQueue::dispatch_forever));
    btn1.rise(queue2.event(ISR_led2));
    
    tk_blink.attach(&Blink_led, 0.25);
    
    th_Mux.start(multiplexado_display);
    tk_cuenta.attach(&contador_up_down, 0.25);
    
    led2 = 0;
    Clear_Str();
    
    while (1) 
    {
        CH0_Val = Canal0.read_u16();
        CH1_Val = Canal1.read_u16();
        CH0_Volt = Canal0.read_u16()*3.3/65536;
        CH1_Volt = Canal1.read_u16()*3.3/65536;
        
        key = kpad.ReadKey();
/*
        if (key == '\0'){ released = 1;}
        if ((key!='\0')&&(released == 1)){
            LCD.locate(0,0);
            LCD.printf("%c",key);
            printf("%c\n",key);
            released = 0;
        }
        led = !led;
        wait_ms(100);
*/      
        if (key == '\0'){ released = 1;}
        if ((key!='\0')&&(released == 1)){
            if (key == 'C'){
                LCD.cls();
                cnt1 ++;
                if (cnt1 == 3){ i = 0;}
                if (cnt1 == 4){
                    cnt1 = 0;
                    Clear_Str();
                }
                key = '\0';
                released = 0;
            }
            else { if (cnt1 == 3){
                       if (i == 6){
                           if (key == 'D'){ cnt1 = 4;}
                       }
                       else { user[i] = key;
                              mask[i] = '*';
                              i ++;
                       }
                   }
            }
            key = '\0';
            released = 0;
        }
        wait_ms(100);  
    }      
}

/*
DigitalOut led1(PTA2);
InterruptIn sw(SW2);
EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread t;

void rise_handler(void) {
    printf("rise_handler in context %p\r\n", Thread::gettid());
    // Toggle LED
    led1 = !led1;
}

void fall_handler(void) {
    printf("fall_handler in context %p\r\n", Thread::gettid());
    // Toggle LED
    led1 = !led1;
}

int main() {
    // Start the event queue
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    printf("Starting in context %p\r\n", Thread::gettid());
    // The 'rise' handler will execute in IRQ context
    sw.rise(rise_handler);
    // The 'fall' handler will execute in the context of thread 't'
    sw.fall(queue.event(fall_handler));
}
*/
