#include "mbed.h"
//<\>
DigitalOut bjtUnd(PTB11,1);
DigitalOut bjtDec(PTC11,1);
DigitalOut led3(PTA2,0);

InterruptIn btnInc(PTE25);
InterruptIn btnDcr(PTE24);

PortOut OutC(PortC, 0x000103A3);

EventQueue queue1(32 * EVENTS_EVENT_SIZE);
EventQueue queue2(32 * EVENTS_EVENT_SIZE);

Thread thread1;
Thread thread2;
Thread thread3;

unsigned char unidades = 0, decenas = 0;

void Incrementar()
{
    unidades ++;
    if (unidades == 10){
        unidades = 0;
        decenas ++;
        if (decenas == 10){
            decenas = 0;
        }
    }    
}
void Decrementar()
{
    unidades --;
    if (unidades == 0xFF){
        unidades = 9;
        decenas --;
        if (decenas == 0xFF){
            decenas = 9;
        }
    }
}
void ContadorAscendente(){
    while(!btnInc){
        Incrementar();
        wait(0.25);   
    }
}
void ContadorDescendente(){
    while(!btnDcr){
        Decrementar();
        wait(0.25);
    }
}
void BinTo7Seg(unsigned char n){
    switch (n){
        case 0: OutC.write(0x80);
                break;
        case 1: OutC.write(0x0102A2);
                break;
        case 2: OutC.write(0x0120);
                break;
        case 3: OutC.write(0x010020);
                break;
        case 4: OutC.write(0x010202);
                break;
        case 5: OutC.write(0x010001);
                break;
        case 6: OutC.write(0x01);
                break;
        case 7: OutC.write(0x0100A2);
                break;
        case 8: OutC.write(0x00);
                break;
        case 9: OutC.write(0x010000); 
                break;    
    }
}
void DisplayMultiplexado()
{
    while(1){
        BinTo7Seg(unidades);
        bjtUnd = 0;
        bjtDec = 1;
        wait(0.01);
        BinTo7Seg(decenas);
        bjtUnd = 1;
        bjtDec = 0;
        wait(0.01);    
    }
}
int main()
{
    thread1.start(callback(&queue1, &EventQueue::dispatch_forever));
    btnInc.fall(queue1.event(ContadorAscendente));
    thread2.start(callback(&queue2, &EventQueue::dispatch_forever));
    btnDcr.fall(queue2.event(ContadorDescendente));
    
    thread3.start(DisplayMultiplexado);
    
    while(1)
    {
        led3 = !led3;
        wait(0.4);
    }
}
