// -------------------------------------
// Projeto Final
// Microcontroladores 2 - 10/10/2016
// Sensor de Temperatura e Umidade DTH11
// -------------------------------------
// Aline Romanini   145157
// Marlon Felipe    121207
// Osvaldo Torezan  147558
// -------------------------------------

// Inclui a Library do mbed
#include "mbed.h"
// Inclui a Library do Sensor de Temperatura e Umidade DHT11
#include "DHT.h"
//Inclui a Library do Display LCD
#include "TextLCD.h"

//Cria uma instância do LCD
TextLCD lcd(PTE0, PTE1, PTE2, PTE3, PTE4, PTE5);

//Cria uma instância do sensor de Temperatura
DHT sensor(PTE20, DHT11);

//Botão para aumentar temperatura de ajuste
DigitalIn btnAumenta(PTC7);
//Botão para diminuir temperatura de ajuste
DigitalIn btnDiminui(PTC0);
//Botão de selecção
DigitalIn btnEnter(PTC5);
//Led interno Vermelho
DigitalOut led(LED1);
//Led interno Verde
DigitalOut ledV(LED2);

//Função que exibe a temperatua no LCD
void ExibeTemperatura(float temperatura)
{
 //Define a posição do LCD na coluna 1 e linha 2, no caso (0,1)
 lcd.locate(0,1);
 //Limpa a linha com 16 espaços
 lcd.printf("                ");
 //Define a posição do LCD na coluna 1 e linha 2, no caso (0,1)
 lcd.locate(0,1);
 //Escreve e temperatua no LCD
 lcd.printf("%.2f",temperatura);
 //Escreve a unidade da temperatura no LCD
 lcd.printf(" oC");
}

//Função Principal
int main()
{
    //Apaga o LED Vermelho da Placa
    led = 1;
    //Acende o LED Verde da Placa
    ledV = 0;
    
    //Define a tempertura inicial de escolha como 25 graus celcius
    float temperatura = 25;
    
    //Escreve o texto abaixo na primeira linha do LCD
    lcd.locate(0,0);
    lcd.printf("Set Temp Celsius");
    
    //Exibe a temperatura inicial no LCD
    ExibeTemperatura(temperatura);
    
    //Laço infinito para que o usuário determine a temperatura do alarme.
    //A temperatura será entre o range de temperaturas que o sensor foi construído
    //ou seja, entre 0 e +50°C
    while(1)
    {
     //Aumenta a temperatura
     if (btnAumenta == 0)
     {
      //Espera 100ms para auemtnar a temperatura
      wait(0.1);
      //Caso o usuário tenha mesmo pressionado o botão, e a temperatura seja menor que +50°C, então aumenta 1°C na temperatura e exibe no LCD
      if (btnAumenta == 0 && temperatura < 50)
      {
        temperatura++;
        ExibeTemperatura(temperatura);
        }
     }
     
     //Diminui a temperatura
     if (btnDiminui == 0)
     {
      //Espera 100ms para auemtnar a temperatura
      wait(0.1);
      //Caso o usuário tenha mesmo pressionado o botão, e a temperatura seja maior que 0°C, então diminui 1°C na temperatura e exibe no LCD
      if (btnDiminui == 0 && temperatura > 0)
      {
        temperatura--;
        ExibeTemperatura(temperatura);
        }
    }   
     
     //Caso o usuário tenha pressionado o botão de "Enter", o firmware encerra o "while" e ativa o alarme
     if (btnEnter == 0)
        break;
    }
    
    //Limpa o display LCD
    lcd.cls();
    //Define o texto na linha 1 e coluna 1, no caso (0,0)
    lcd.locate(0,0);
    //Escreve "Alarme Ativado"
    lcd.printf("Alarm Activate");
    
    while(1)
    {
     //Chama a função da biblioteca do sensor e requisita a leitura de dados do mesmo
     sensor.readData();
     //Chama a função da biblioteca do sensor e requisita a temperatura em graus Celcius
     float temperaturaS = sensor.ReadTemperature(CELCIUS);
     //Exibe a temperatura ambiente no display LCD
     ExibeTemperatura(temperaturaS);
     
     //Caso a temperatura ambiente seja maior que a temperatura de alarme
     if (temperaturaS > temperatura)
     {
      // Dispara o alarme com um sinal luminoso no LED Vermelho da Placa
      //Apaga o LED Verde
      ledV = 1;
      //Acende o LED Vermelho
      led = 0;
      wait(0.1);
      led = 1;
      wait(0.1);   
      //}    
     }
     else
        ledV = 0; //Acende LED Verde
     
     //Espera 1 segundo para realizar uma nova leitura do sensor
     wait(1);
    }
}