// -------------------------------------
// Desafio 02
// Microcontroladores 2 - 10/10/2016
// Acelerômetro 
// -------------------------------------
// Aline Romanini   145157
// Marlon Felipe    121207
// Osvaldo Torezan  147558
// -------------------------------------

// Inclui a Library do mbed
#include "mbed.h"
// Inclui a Library do Acelerômetro MMA8451Q
#include "MMA8451Q.h"
// Define o endereço I2C do acelerômetro onboard
#define MMA8451_I2C_ADDRESS (0x1d<<1)

// O programa contém um loop infinito principal que fica verificando o ângulo
// de inclinação nas direções cartesianas X, Y e X, aravés do acelerômetro onboard.

// Ao detectar uma inclinação no eixo X maior que 45 graus, o programa acende o LED
// vermelho e permanece até a inclinação ser menor que 45 graus ou maior que 54 graus 
// outro eixo.

// Ao detectar uma inclinação no eixo Y maior que 45 graus, o programa acende o LED
// verde, e a mesma regra do eixo X é válida.

// Ao detectar uma inclinação no eixo Z maior que 45 graus, o programa acende o LED
// azul, e a regra anterior para os outros eixos permanece válida.

// Inicio do programa (função principal 'main')
int main()
{
 // Define uma variável com nome "acc" para o acelerômetro onboard
 MMA8451Q acc(PTE25, PTE24,MMA8451_I2C_ADDRESS);
 
 // Define o LED 1 da placa (vermelho) como uma saída PWM na variável "rled"
 PwmOut rled(LED1);
 // Define o LED 2 da placa (verde) como uma saída PWM na variável "gled"
 PwmOut gled(LED2);
 // Define o LED 3 da placa (azul) como uma saída PWM na variável "bled"
 PwmOut bled(LED3);
 
 // Apaga led Vermelho
 rled = 1.0;
 // Apaga led Verde
 gled = 1.0;
 // Apaga led Azul
 bled = 1.0;
 
 // Laço infinito principal
 while(1)
 {
  // Caso o ângulo mensurado pelo acelerômetro no eixo X seja menor ou igual a 45 graus
  if (abs(acc.getAccX()) <= 0.5)
    rled = 1.0; // Apaga led vermelho
  else
  {
    // Apaga os leds verde e azul e acende o led vermelho caso o ângulo seja maior que 45 graus no eixo X
    rled = 0.0; 
    gled = 1.0;
    bled = 1.0;
  }

  // Caso o ângulo mensurado pelo acelerômetro no eixo Y seja maior ou igual a 45 graus
  if (abs(acc.getAccY()) <= 0.5)
    gled = 1.0; // Apaga o led verde
  else
  {
    // Apaga os leds azul e vermelho e acende o led verde caso o ângulo seja maior que 45 graus no eixo Y
    rled = 1.0;
    gled = 0.0;
    bled = 1.0;
  }

  // Caso o ângulo mensurado pelo acelerômetro no eixo Z seja maior ou igual a 45 graus
  if (abs(acc.getAccZ()) <= 0.5)
    bled = 1.0; // Apaga o led azul
  else
  {
    // Apaga os leds verde e vermelho e acende o led azuk caso o ângulo seja maior que 45 graus no eixo Z
    rled = 1.0;
    gled = 1.0;
    bled = 0.0;
  }
  
  // Espera 100 ms
  wait(0.1);
  
 }   
}