 #include <iostream>
 #include <stdio.h>
 #include <stdlib.h>
 #include <stdint.h>
 #include <bitset>

// #include <string>
// #include <typeinfo>

#include "log.h"

Log::Log(uint16_t ttime, uint8_t fsmtype, uint8_t event,uint16_t date)
{
    uint16_t h=ttime/100;
    uint16_t m=ttime%100;
    uint16_t data=fsmtype<<12|event<<11;
    h=h<<6;
    _date=date;
    _data=data|h|m;
}

Log::Log(){_data=0;}

uint16_t Log::getsize()
{
	return sizeof(_data);
}
uint16_t Log::getDate() const
{
    return _date;
}

bool Log::getFsmtype() const
{
	return (_data & (1 << 12))!=0;
}

bool Log::getEvent() const
{
	return (_data & (1 << 11))!=0;
}

uint16_t Log::getTime() const
{
char temp[5];
//string z;
uint16_t x = (_data & 0x7c0)>>6;
uint16_t y = (_data & 0x3F);
//cout<<x<<" "<<y<<endl;
if(y<=9)
   sprintf(temp, "%d0%d", x,y);
  //z=to_string(x)+"0"+to_string(y);
else
    sprintf(temp, "%d%d", x,y);
  //z =to_string(x)+to_string(y);
  temp[5]='\0';
  //std::string z(temp);
  //cout<<"temp "<<temp<<endl;
return atoi(temp);
}

Log& Log::operator =(const Log &a){ //  b.operator=(a);

    uint16_t date=a.getDate();
    _date=date;
    uint16_t h=a.getTime()/100;
    uint16_t m=a.getTime()%100;
    uint16_t data=((a.getFsmtype())<<12)|((a.getEvent())<<11);
    h=h<<6;
    _data=data|h|m;
    return *this;
}

void Log::setLog(uint16_t ttime, uint8_t fsmtype, uint8_t event,uint16_t date)
{
    uint16_t h=ttime/100;
    uint16_t m=ttime%100;
    uint16_t data=fsmtype<<12|event<<11;
    h=h<<6;
    _data=data|h|m;
    _date=date;
}

