#ifndef CASEFSM_FSM_H_
#define CASEFSM_FSM_H_
#include <CaseState.h>
#include "mbed.h"

#include <CaseEvents.h>

struct SwitchPosition;
struct RFIDEvent;

class CaseFsmStates
{
public:
    CaseFsmStates();

    CaseState* deviceEmptyState();
    CaseState* deviceFullState();
    CaseState* phoneUndetectedState();
    CaseState* phoneDetectedState();
    CaseState* currentState();

    void currentState(CaseState* state);
    ~CaseFsmStates();

private:

    CaseState* deviceEmptyState_;
    CaseState* deviceFullState_;
    CaseState* phoneUndetectedState_;
    CaseState* phoneDetectedState_;
    CaseState* currentState_;

    Timer timer;

};

class CaseFsm
{
public:
    CaseFsm();
    Timeout rfidTimeout;
    void timerCallback();
    template <typename Event>
    void handle(Event& event) {
        CaseState* state = states_.currentState()->handle(event);
        if(state==states_.deviceFullState()) {
            rfidTimeout.attach(this, &CaseFsm::timerCallback, 5.0);
        }
        if(state==states_.deviceEmptyState()) {
            rfidTimeout.detach();
        }
        if(state==states_.phoneDetectedState()) {
            rfidTimeout.detach();
        }
        states_.currentState(state);
    }
    bool DeviceInFullState(){
        return states_.currentState() == states_.deviceFullState();
        };
    virtual ~CaseFsm() {}

private:
    CaseFsmStates states_;

};
#endif /* ifndef CASEFSM_FSM_H_ */
