#ifndef MOTIONFSM_FSM_H_
#define MOTIONFSM_FSM_H_
#include <State.h>
#include "mbed.h"

#include <Events.h>

struct Stop;
struct Move;

class FsmStates {
  public:
  FsmStates();
  
  State* movingState();
  State* stacionaryState();
  State* currentState();
  
  void currentState(State* state);

  ~FsmStates();

  private:
  
  State* movingState_;
  State* stacionaryState_;
  State* currentState_;
  
  Timer timer;
  
};

class Fsm {
  public:
  Fsm();
  template <typename Event> 
  void handle(Event& event){
    State* state = states_.currentState()->handle(event);
    states_.currentState(state);
  }
  
  virtual ~Fsm() {}
  FsmStates states_;
  private:
  

};
#endif /* ifndef MOTIONFSM_FSM_H_ */
