#ifndef __ENEMY_UNIT
#define __ENEMY_UNIT
#include "Constants.h"
#include <stdint.h>

struct Enemy
{
    struct Enemy * prev;
    struct Enemy * next;
    int16_t x_pos;
    int16_t y_pos;
    int16_t x_vel;
    int16_t y_vel;
    int16_t health;
    int16_t maxHealth;
    int16_t freezeTimer;
    int16_t gunTimer;
};

extern struct Enemy * enemyPTR;
extern int16_t enemyCount;

//User interface functions.
void addEnemy(int16_t x_pos, int16_t x_vel,int16_t y_vel, int16_t health);
void clearEnemies(); 
void freezeEnemies();
int16_t getEnemyBulletPos(struct Enemy * enemy,int8_t XOrY);
int8_t dealDamageToEnemy(struct Enemy * enemy, int8_t damage);
void callMultiFuncEnemy();

//Functions user does not need to worry about.
void removeEnemy(struct Enemy * removePTR); 
void enemyMovement(struct Enemy * enemy);
void enemyMovement_ALL();//mf
void updateEnemyTimers(struct Enemy * enemy);
void updateEnemyTimers_ALL();//mf
void removeEnemyIfOOB(struct Enemy * enemy);
void removeEnemyIfOOB_ALL(); //mf


#endif