#include "Enemy.h"

struct Enemy * enemyPTR;
int16_t enemyCount;

void addEnemy(int16_t x_pos, int16_t x_vel,int16_t y_vel, int16_t health)
{
    struct Enemy * newEnemy = (struct Enemy *) malloc(sizeof(struct Enemy));
    newEnemy->x_pos = x_pos;
    newEnemy->y_pos = 0;
    newEnemy->x_vel = x_vel;
    newEnemy->y_vel = y_vel;
    newEnemy->health = health;
    newEnemy->maxHealth = health;
    newEnemy->freezeTimer = 0;
    newEnemy->gunTimer = 0;
    enemyCount++;
    if(enemyCount==1)
    {
        newEnemy->prev = newEnemy;
        newEnemy->next = newEnemy;
        enemyPTR = newEnemy;
        return;
    }
    struct Enemy * tempNext = enemyPTR->next;
    enemyPTR->next = newEnemy;
    newEnemy->prev = enemyPTR;
    tempNext->prev = newEnemy;
    newEnemy->next = tempNext;
}
void removeEnemy(struct Enemy * removePTR)
{
    if(enemyCount <= 0)
        return;
    enemyCount--;
    if(enemyCount == 0)
        enemyPTR = (struct Enemy *) 0;
    else
    {
        enemyPTR = removePTR->prev;
        struct Enemy * tempNext = removePTR->next;
        enemyPTR->next = tempNext;
        tempNext->prev = enemyPTR;
    }
    free(removePTR);
}
void clearEnemies()
{
    while(enemyCount)
        removeEnemy(enemyPTR);
}
void freezeEnemies()
{
    int i;
    for(i = enemyCount; i; i--)
    {
        enemyPTR->freezeTimer = FREEZE_TIME;
        enemyPTR = enemyPTR->next;
    }
}
int16_t getEnemyBulletPos(struct Enemy * enemy,int8_t XOrY)
{
    if(XOrY)
        return enemy->x_pos+ENEMY_WIDTH/2-BULLET_SIZE/2;
    return enemy->y_pos+ENEMY_HEIGHT-BULLET_SIZE/2;
}
void enemyMovement(struct Enemy * enemy)
{
    if(enemy->freezeTimer)
        return;
    if(enemy->x_pos + ENEMY_WIDTH >= LCD_WIDTH && enemy->x_vel>0)
        enemy->x_vel = -enemy->x_vel;
    else if(enemy->x_pos<=0 && enemy->x_vel<0)
        enemy->x_vel = -enemy->x_vel;
    enemy->x_pos+=enemy->x_vel;
    enemy->y_pos+=enemy->y_vel;
}

void enemyMovement_ALL()
{
    int i;
    for(i = enemyCount; i; i--)
    {
        enemyMovement(enemyPTR);
        enemyPTR = enemyPTR->next;
    }
}
void updateEnemyTimers(struct Enemy * enemy)
{
    enemy->freezeTimer = enemy->freezeTimer ? (enemy->freezeTimer -1) : 0;
    enemy->gunTimer = enemy->gunTimer ? (enemy->gunTimer  -1) : ENEMY_BULLET_WAIT_TIME ;
}
void updateEnemyTimers_ALL()
{
    int i;
    for(i = enemyCount;i;i--)
    {
        updateEnemyTimers(enemyPTR);
        enemyPTR = enemyPTR->next;
    }
}
void removeEnemyIfOOB(struct Enemy * enemy)
{
    if(enemy->y_pos>=LCD_HEIGHT)
        removeEnemy(enemy);
}
void removeEnemyIfOOB_ALL()
{
    int i;
    for(i = enemyCount; i ;i--)
    {
        enemyPTR = enemyPTR->next;
        removeEnemyIfOOB(enemyPTR);
    }
}
int8_t dealDamageToEnemy(struct Enemy * enemy, int8_t damage)
{
    if(enemy->health<=damage)
    {
        removeEnemy(enemy);
        return 1;
    }
    enemy->health-=damage;
    return 0;
}
void callMultiFuncEnemy()
{
    removeEnemyIfOOB_ALL();//DEBUG!!!
    updateEnemyTimers_ALL();//DEBUG!!!
    enemyMovement_ALL();
}