#ifndef __BULLET_UNIT
#define __BULLET_UNIT
#include "Constants.h"
#include <stdint.h>

struct Bullet
{
    struct Bullet * prev;
    struct Bullet * next;
    int16_t x_pos;
    int16_t y_pos;
    int16_t x_vel;
    int16_t y_vel;
    int8_t powerShot;
    int8_t isPlayerBullet;
    int8_t isBombBullet;
};

extern struct Bullet * enemyBulletPTR;
extern struct Bullet * playerBulletPTR;
extern int16_t enemyBulletCount;
extern int16_t playerBulletCount;

//User interface functions.
void addEnemyBullet(int16_t x_pos, int16_t y_pos);
void addPlayerBullet(int16_t x_pos, int16_t y_pos, int16_t x_vel, int16_t y_vel, int8_t power, int8_t bomb);
void clearBullets();
void callMultiFuncBullet();
void removeBullet(struct Bullet * bullet);

//Functions user does not need to worry about.
void bulletMovement(struct Bullet * bullet);
void bulletMovement_ALL();
void removeBulletIfOOB(struct Bullet * bullet);
void removeBulletIfOOB_ALL(); 
#endif