#include "Bullet.h"

struct Bullet * enemyBulletPTR;
struct Bullet * playerBulletPTR;
int16_t enemyBulletCount;
int16_t playerBulletCount;

void addEnemyBullet(int16_t x_pos, int16_t y_pos)
{
    struct Bullet * newBullet = (struct Bullet *) malloc(sizeof(struct Bullet));
    newBullet->x_pos = x_pos;
    newBullet->y_pos = y_pos;
    newBullet->x_vel = 0;
    newBullet->y_vel = DEFAULT_BULLET_SPEED;
    newBullet->isPlayerBullet = 0;
    enemyBulletCount++;
    if(enemyBulletCount==1)
    {
        newBullet->prev = newBullet;
        newBullet->next = newBullet;
        enemyBulletPTR = newBullet;
        return;
    }
    struct Bullet * tempNext = enemyBulletPTR->next;
    enemyBulletPTR->next = newBullet;
    newBullet->prev = enemyBulletPTR;
    tempNext->prev = newBullet;
    newBullet->next = tempNext;
}
void addPlayerBullet(int16_t x_pos, int16_t y_pos, int16_t x_vel, int16_t y_vel, int8_t power, int8_t bomb)
{
    struct Bullet * newBullet = (struct Bullet *) malloc(sizeof(struct Bullet));
    newBullet->x_pos = x_pos;
    newBullet->y_pos = y_pos;
    newBullet->x_vel = x_vel;
    newBullet->y_vel = y_vel;
    newBullet->powerShot = power;
    newBullet->isPlayerBullet = 1;
    newBullet->isBombBullet = bomb;
    playerBulletCount++;
    if(playerBulletCount==1)
    {
        newBullet->prev = newBullet;
        newBullet->next = newBullet;
        playerBulletPTR = newBullet;
        return;
    }
    struct Bullet * tempNext = playerBulletPTR->next;
    playerBulletPTR->next = newBullet;
    newBullet->prev = playerBulletPTR;
    tempNext->prev = newBullet;
    newBullet->next = tempNext;   
} 
void removeBullet(struct Bullet * removePTR)
{
    if(removePTR->isPlayerBullet)
    {
        if(playerBulletCount <= 0)
            return;
        playerBulletCount--;
        if(playerBulletCount == 0)
            playerBulletPTR = (struct Bullet *) 0;
        else
        {
            playerBulletPTR = removePTR->prev;
            struct Bullet * tempNext = removePTR->next;
            playerBulletPTR->next = tempNext;
            tempNext->prev = playerBulletPTR;
        }
    }
    else
    {
        if(enemyBulletCount <= 0)
            return;
        enemyBulletCount--;
        if(enemyBulletCount == 0)
            enemyBulletPTR = (struct Bullet *) 0;
        else
        {
            enemyBulletPTR = removePTR->prev;
            struct Bullet * tempNext = removePTR->next;
            enemyBulletPTR->next = tempNext;
            tempNext->prev = enemyBulletPTR;
        }
    }
    free(removePTR);
}
void clearBullets()
{
    while(enemyBulletCount)
        removeBullet(enemyBulletPTR);
    while(playerBulletCount)
        removeBullet(playerBulletPTR);
}

//Specific to 1 Bullet
void bulletMovement(struct Bullet * bullet)
{
    bullet->x_pos+=bullet->x_vel;
    bullet->y_pos+=bullet->y_vel;
}
void bulletMovement_ALL()
{
    int i;
    for(i = playerBulletCount; i; i--)
    {
        bulletMovement(playerBulletPTR);
        playerBulletPTR = playerBulletPTR->next;
    }
    for(i = enemyBulletCount; i; i--)
    {
        bulletMovement(enemyBulletPTR);
        enemyBulletPTR = enemyBulletPTR->next;
    }
} 
void removeBulletIfOOB(struct Bullet * bullet)
{
    int xp = bullet->x_pos;
    int yp = bullet->y_pos;
    if(bullet->isPlayerBullet)
    {
        if(!(bullet->isBombBullet))
        {
            if(yp <= -BULLET_SIZE)
                removeBullet(bullet);
            return;
        }
        if((xp <= -BULLET_SIZE)||(xp>=LCD_WIDTH)||(yp <= -BULLET_SIZE)||(yp>=LCD_HEIGHT))
            removeBullet(bullet);
    }  
    else
    {
        if(yp >= LCD_HEIGHT)
            removeBullet(bullet);
    } 
}
void removeBulletIfOOB_ALL()
{
    int i;
    for(i = enemyBulletCount; i; i--)
    {
        enemyBulletPTR = enemyBulletPTR->next;
        removeBulletIfOOB(enemyBulletPTR);
    }
    for(i = playerBulletCount; i; i--)
    {
        playerBulletPTR = playerBulletPTR->next;
        removeBulletIfOOB(playerBulletPTR);
    }
}
void callMultiFuncBullet()
{
    removeBulletIfOOB_ALL();   
    bulletMovement_ALL();
}