#ifndef __POWER_UP
#define __POWER_UP
#include "Constants.h"
#include <stdint.h>
enum PowerUpType
{
    PU_RapidFire,
    PU_PowerShot,
    PU_FreezeEnemies,
    PU_WideShot,
    PU_Explosion,
    PU_BonusHealth,
    PU_Shield
    
};

struct PowerUp
{
    struct PowerUp * prev;
    struct PowerUp * next;
    int16_t x_pos;
    int16_t y_pos;
    enum PowerUpType type;
    int expirationTimer;
};

extern struct PowerUp * powerUpPTR;
extern int16_t powerUpCount;

//User interface functions.
void addPowerUp(int16_t x_pos, int16_t y_pos);
void removePowerUp(struct PowerUp * powerUp);
void clearPowerUps();
void callMultiFuncPowerUp();

//Functions user does not need to worry about.
enum PowerUpType getRandomType();//-------------------------------------NEEDS RANDOM!!!
void updatePowerUpTimer(struct PowerUp * powerUP);
void updatePowerUpTimer_All();
void removePowerUpIfExpired(struct PowerUp * powerUp);
void removePowerUpIfExpired_All();
#endif