#ifndef __GAME
#define __GAME
#include "Enemy.h"
#include "Bullet.h"
#include "Player.h"
#include "PowerUp.h"
#include "RandomVar.h"
#include <math.h>
extern int16_t level;
extern int16_t levelScore;
extern int16_t totalScore;
extern int16_t lives;
extern int8_t  X_DIR;
extern int8_t  Y_DIR;
extern int8_t didUserRequestFire;

void newGame();
void newLevel();
int8_t shouldAddEnemy();
void addRandomEnemy();
void addWideShotBullets();
void callMultiFunc();
int8_t didBulletHitEnemy(struct Enemy * enemy, struct Bullet * bullet);
void checkIfBulletsHitEnemies();
void enemiesFireBullet();
void firePlayerBullet();
void usePowerUpAbility();
void generateExplosion();
int8_t didPlayerHitPowerUp(struct PowerUp * powerUp);
int8_t didBulletHitPlayer(struct Bullet * bullet);
int8_t didPlayerCollideWithEnemy(struct Enemy * enemy);
void collideBulletsWithPlayer();
void collideWithEnemies();
void pickUpPowerUps();
void loopIteration();
char didLoseLife();
char isGameOver();
char didLevelUp();
#endif