#include "PowerUp.h"

struct PowerUp * powerUpPTR;
int16_t powerUpCount;

enum PowerUpType getRandomType()//fix!!!
{
    int randVal = randomInt(0,NUMBER_OF_POWER_UPS_TYPES-1);
    switch(randVal)
    {
        case 0: return PU_RapidFire;
        case 1: return PU_PowerShot;
        case 2: return PU_FreezeEnemies;
        case 3: return PU_WideShot;
        case 4: return PU_Explosion;
        case 5: return PU_BonusHealth;
        case 6: return PU_Shield;
    }
    return PU_BonusHealth;
}
void addPowerUp(int16_t x_pos, int16_t y_pos)
{
    struct PowerUp * newPowerUp = (struct PowerUp *) malloc(sizeof(struct PowerUp));
    newPowerUp->x_pos = x_pos;
    newPowerUp->y_pos = y_pos;
    newPowerUp->type = getRandomType();
    newPowerUp->expirationTimer = POWER_UP_EXPERATION_TIME;
    powerUpCount++;
    if(powerUpCount==1)
    {
        newPowerUp->prev = newPowerUp;
        newPowerUp->next = newPowerUp;
        powerUpPTR = newPowerUp;
        return;
    }
    struct PowerUp * tempNext = powerUpPTR->next;
    powerUpPTR->next = newPowerUp;
    newPowerUp->prev = powerUpPTR;
    tempNext->prev = newPowerUp;
    newPowerUp->next = tempNext;
}

void removePowerUp(struct PowerUp * removePTR)
{
    if(powerUpCount<=0)
        return;
    powerUpCount--;
    if(powerUpCount == 0)
        powerUpPTR = (struct PowerUp *) 0;
    else
    {
        powerUpPTR = removePTR->prev;
        struct PowerUp * tempNext = removePTR->next;
        powerUpPTR->next = tempNext;
        tempNext->prev = powerUpPTR;
    }
    free(removePTR);
}
void clearPowerUps()
{
    while(powerUpCount)
        removePowerUp(powerUpPTR);
}
void updatePowerUpTimer(struct PowerUp * powerUp)
{
    powerUp->expirationTimer = powerUp->expirationTimer ? (powerUp->expirationTimer - 1) : 0;
}
void updatePowerUpTimer_All()
{
    int i;
    for(i = powerUpCount; i; i--)
    {
        updatePowerUpTimer(powerUpPTR);
        powerUpPTR = powerUpPTR->next;
    }
}
void removePowerUpIfExpired(struct PowerUp * powerUp)
{
    if(!(powerUp->expirationTimer))
        removePowerUp(powerUp);
}
void removePowerUpIfExpired_All()
{
    int i;
    for(i = powerUpCount; i; i--)
    {
        powerUpPTR = powerUpPTR->next;
        removePowerUpIfExpired(powerUpPTR);
    }
}
void callMultiFuncPowerUp()
{
    removePowerUpIfExpired_All();
    updatePowerUpTimer_All();
}