#include "Player.h"

struct Player player;

void resetPlayer()
{
    player.x_pos = LCD_WIDTH/2-PLAYER_WIDTH/2;
    player.y_pos = LCD_HEIGHT-PLAYER_HEIGHT-HEALTH_BAR_SIZE;
    player.health = PLAYER_STARTING_HEALTH;
    player.rapidFireTimer = 0;
    player.powerShotTimer = 0;
    player.wideShotTimer = 0;
    player.shieldTimer = 0;
    player.gunTimer = 0;
    //player.fastMovementTimer = 0;
    player.RFT_Timer = 0;
    //player.speedFireTimer = 0;
}
void movePlayer(int8_t x_dir, int8_t y_dir)
{
    player.x_pos += PLAYER_VELOCITY * x_dir;
    player.y_pos += PLAYER_VELOCITY * y_dir;
    //}
    if(player.x_pos<=0)
        player.x_pos=0;
    else if(player.x_pos>=LCD_WIDTH-PLAYER_WIDTH)
        player.x_pos = LCD_WIDTH-PLAYER_WIDTH;
    if(player.y_pos<=0)
        player.y_pos = 0;
    else if(player.y_pos>=LCD_HEIGHT-PLAYER_HEIGHT-HEALTH_BAR_SIZE)
        player.y_pos = LCD_HEIGHT-PLAYER_HEIGHT-HEALTH_BAR_SIZE;
}
void updatePlayerTimers()
{
    player.rapidFireTimer = player.rapidFireTimer ? player.rapidFireTimer-1 : 0;
    player.powerShotTimer = player.powerShotTimer ? player.powerShotTimer-1 : 0;
    player.wideShotTimer = player.wideShotTimer ? player.wideShotTimer-1 : 0;
    player.shieldTimer = player.shieldTimer ? player.shieldTimer-1 : 0;
    player.gunTimer = player.gunTimer ? player.gunTimer-1 : 0;
    //player.fastMovementTimer = player.fastMovementTimer ? player.fastMovementTimer-1 : 0;
    //player.speedFireTimer = player.speedFireTimer ? player.speedFireTimer-1 : 0;
    player.RFT_Timer = player.RFT_Timer ? player.RFT_Timer-1 : RFT_PERIOD;
}
int16_t getPlayerBulletPos(int8_t XorY)
{
    if(XorY)
        return player.x_pos+PLAYER_WIDTH/2-BULLET_SIZE/2;
    return player.y_pos-BULLET_SIZE/2;
}
int8_t dealDamageToPlayer()
{
    if(player.shieldTimer)
        return 0;
    player.health--;
    return !(player.health) ? 1 : 0;
}
int8_t shouldFire(int8_t didUserRequestFire)
{
    if(player.rapidFireTimer)
    {
        return !player.RFT_Timer ? 1 : 0;     
    }
    return !player.gunTimer && didUserRequestFire ? 1 : 0;
}
void callMultiFuncPlayer()
{
    updatePlayerTimers();
}
/*
int8_t callMultiFuncPlayer(int8_t x_dir, int8_t y_dir, int8_t didUserRequestFire)
{
    movePlayer(x_dir,y_dir);
    updatePlayerTimers();
    return shouldFire(didUserRequestFire);
}*/