#ifndef _SOFT_PWM_
#define _SOFT_PWM_

#include "mbed.h"

class SoftPwm
{
        private:
            float period;           //PWM period
            float dutyCycle;        //Duty cycle of the PWM
            Timer timer;            //used for location within the cycle
            
        public:
            //constructor - requires initial period and duty cycle values 
            SoftPwm(float initalPeriod, float initialDutyCycle); 
            
            float getPeriod();      //return current period value
            float getDutyCycle();   //returns current Duty Cycle value
            
            void setPeriod(float newPeriod); //updates the period to a specified value 
            void setDutyCycle(float newDutyCycle); //updates the Duty cycle to the specified value
            
            bool isOn();            //checks if value is on (true) or off (false) phase.
};

#endif 