#include "soft_pwm.h"



SoftPwm::SoftPwm(float initalPeriod, float initialDutyCycle)
{
    this->period = initalPeriod;            //set initial Period 
    this->dutyCycle = initialDutyCycle;     //set initial Duty Cycle
    this->timer.start();                    //PWM timer start
}

float SoftPwm::getPeriod(){      //return current period value
    return this->period;
}

float SoftPwm::getDutyCycle(){   //returns current Duty Cycle value
    return this->dutyCycle;
}

void SoftPwm::setPeriod(float newPeriod){ //updates the period to a specified value 
    this->period = newPeriod;
    return;
}

void SoftPwm::setDutyCycle(float newDutyCycle){ //updates the Duty cycle to the specified value
    this->dutyCycle = newDutyCycle;
}

bool SoftPwm::isOn(){
    float onPhaseDuration = this->dutyCycle * this->period;
    
    float currentTime = this->timer.read();
    
    if (currentTime > period) this->timer.reset();
    
    if (currentTime < onPhaseDuration){
        return true;
    } else {
        return false;
    }
    
}
