/*
This is a program for globlelized controller of whole DOGO
F746ZG
*/

#include "mbed.h"
//#include "LSM9DS0_SH.h"
#define DEBUG       0

#define pi          3.141592f
#define d2r         0.01745329f

#define Rms         5000            //TT rate
#define dt          0.015f
#define Task_1_NN   2
#define Task_2_NN   5
#define Task_3_NN   3
#define Task_4_NN   39

//Structure
#define Buff_size   16              //Serial Buffer

#define constrain(amt,low,high) ((amt)<(low)?(low):((amt)>(high)?(high):(amt)))

//Dog Specification
#define BODYLENGTH 300  //mm
#define BODYWIDTH 190  //mm
#define BODYHEIGHT 260  //mm
#define MINLEGLENGTH 120  //mm
#define MAXLEGLENGTH 280  //mm
#define STEPLENGTH 50   //mm
#define STEPHEIGHT 30   //mm
#define MOVESPEED  20   //20mm/s
//#define ANGLE1RANGE pi/3  //degree
//#define ANGLE2RANGE pi/3  //degree

//≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡GPIO registor≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡//
//╔═════════════════╗
//║    Structure    ║
//╚═════════════════╝
DigitalOut  LD1(PA_5);               //detection
DigitalOut  LD2(PB_7);               //detection
DigitalOut  LD3(PB_14);              //detection
InterruptIn button(USER_BUTTON);    //Button press;

//╔═════════════════╗
//║     Serial      ║
//╚═════════════════╝
Serial      Debug(PD_8, PD_9);      //Serial_3 reg(TX RX) USB port

Serial      LF_Cmd(PD_5, PD_6);     //Serial_2
DigitalOut  LF_CS(PD_7);

Serial      LH_Cmd(PC_12, PD_2);    //Serial_5
DigitalOut  LH_CS(PG_2);

Serial      RF_Cmd(PG_14, PC_7);    //Serial_6
DigitalOut  RF_CS(PA_5);

Serial      RH_Cmd(PE_8, PE_7);     //Serial_7
DigitalOut  RH_CS(PA_5);
//■■■■■■■■■■■■■■■■■■■■■■■■■■■end of GPIO registor■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■//


//≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡Varible registor≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡//
//╔═════════════════╗
//║    Structure    ║
//╚═════════════════╝
Ticker  TT;                         //call a timer
uint8_t Task_1_count = 0;           //1st prior task count
uint8_t Task_2_count = 0;           //2nd prior task count
uint8_t Task_3_count = 0;           //3nd prior task count
uint8_t Task_4_count = 0;           //24nd prior task count
uint8_t Flag_1 = 0;                 //1st prior task flag
uint8_t Flag_2 = 0;                 //2nd prior task flag
uint8_t Flag_3 = 0;                 //3nd prior task flag
uint8_t Flag_4 = 0;                 //4nd prior task flag


//╔═════════════════╗
//║   I/O Serial    ║
//╚═════════════════╝
uint8_t Buff[Buff_size];
uint8_t Recieve_index = 0;

//╔═════════════════╗
//║   Dog Posture   ║
//╚═════════════════╝
float bodyCoordinate[4][3] = {              
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
};

float pawCoordinate[4][3] = {              
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
};

float bodyCentroid[3] = {0, 0, 0};
float pawCentroid[3] = {0, 0, 0};
float legLength[4] = {0, 0, 0, 0};

float legAngle[4][2] = {              
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
};

uint8_t walking  = 0;
uint8_t stepOrder[4] = {2, 4, 1, 3};
uint8_t stepOrderIdx = 0;
float stepIncrement = 0;
bool liftLegBool = false;
bool forwardLegBool = false;
bool dropLegBool = false;
bool moveCentroidBool = false;
bool inLoopFlag1 = false;
bool inLoopFlag2 = false;
bool inLoopFlag3 = false;
bool inLoopFlag4 = false;
int liftCounter = 0;
int forwardCounter = 0;
int dropCounter = 0;
int centroidCounter = 0;
float ANGLE1RANGE = pi/3;
float ANGLE2RANGE = pi/3;

//╔═════════════════╗
//║     Command     ║
//╚═════════════════╝
uint8_t LF_Cmd_Hex[3] = {0x00, 0x00, 0x00};
uint8_t LH_Cmd_Hex[3] = {0x00, 0x00, 0x00};
uint8_t RF_Cmd_Hex[3] = {0x00, 0x00, 0x00};
uint8_t RH_Cmd_Hex[3] = {0x00, 0x00, 0x00};
//■■■■■■■■■■■■■■■■■■■■■■■■■■■end of Varible registor■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■//


//≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡Function registor≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡//
void    init_TIMER();           //set TT_main() rate
void    TT_main();              //timebase function rated by TT
void    Rx_irq();

void    pressed();
void    released();
void    init_posture();
void    walk();
void    liftLeg(uint8_t);
void    forwardLeg(uint8_t);
void    dropLeg(uint8_t);
void    moveCentroid(uint8_t);
void    convertToPolar(float (&bodyCoordinate)[4][3], float (&pawCoordinate)[4][3], float (&legLength)[4], float (&legAngle)[4][2]);
void    calTriCentroid(float (&point1)[3], float (&point2)[3], float (&point3)[3], float (&centroid)[3]);
void    calRecCentroid(float (&points)[4][3], float (&centroid)[3]);
void    converToHexCmd();
//■■■■■■■■■■■■■■■■■■■■■■■■■■■end of Function registor■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■//


//≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡main funtion≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡//
int main()
{
    Debug.baud(115200);                     //set baud rate
    LF_Cmd.baud(115200);
    LH_Cmd.baud(115200);
    RF_Cmd.baud(115200);
    RH_Cmd.baud(115200);

    wait_ms(10);
    init_TIMER();                           //start TT_main
    init_posture();                         //init dog posture

    Debug.attach(&Rx_irq,Serial::RxIrq);    //Start recieving message

    
    button.fall(&pressed);                  //button pressed

    liftLegBool = true;
    
    LF_CS = 1;
    wait_ms(200);
    
    while(1) {                              //main() loop

//        if(Debug.readable()) {
//            Buff[Recieve_index] = Debug.getc();
//            Debug.putc(Buff[Recieve_index]);
//            Recieve_index = Recieve_index + 1;
//        }

//        if(device.readable()) {
//            pc.putc(device.getc());
//        }
        if((Flag_3 == 1)&&(walking == 1)) {               //check pending
            //Task_3 start
            walk();
            converToHexCmd();
            //Task_3 done
            Flag_3 = 0;                 //clear pending
            //Task_3 = 0;
        }
        if((Flag_4 == 1)&&(walking == 1)) {               //check pending          
            //Task_4 start      
            LF_CS = 0;
            wait_us(20);
            LF_Cmd.putc(LF_Cmd_Hex[0]);
            LF_Cmd.putc(LF_Cmd_Hex[1]);
            LF_Cmd.putc(LF_Cmd_Hex[2]);
            LF_Cmd.putc('Q');
            wait_us(180);
            LF_CS = 1;
            //wait(1);
            
            RF_CS = 0;
            wait_us(20);
            RF_Cmd.putc(RF_Cmd_Hex[0]);
            RF_Cmd.putc(RF_Cmd_Hex[1]);
            RF_Cmd.putc(RF_Cmd_Hex[2]);
            RF_Cmd.putc('Q');
            wait_us(180);
            RF_CS = 1;
            //wait(1);
            
            RH_CS = 0;
            wait_us(20);
            RH_Cmd.putc(RH_Cmd_Hex[0]);
            RH_Cmd.putc(RH_Cmd_Hex[1]);
            RH_Cmd.putc(RH_Cmd_Hex[2]);
            RH_Cmd.putc('Q');
            wait_us(180);
            RH_CS = 1;
            //wait(1);
            
            LH_CS = 0;
            wait_us(20);
            LH_Cmd.putc(LH_Cmd_Hex[0]);
            LH_Cmd.putc(LH_Cmd_Hex[1]);
            LH_Cmd.putc(LH_Cmd_Hex[2]);
            LH_Cmd.putc('Q');
            wait_us(180);
            LH_CS = 1;
            //wait(1);     
            //Task_4 done
            
#if DEBUG == 2
    printf("LF_Cmd  %d  %d  %d\n", LF_Cmd_Hex[0], LF_Cmd_Hex[1], LF_Cmd_Hex[2]);
    printf("RF_Cmd  %d  %d  %d\n", RF_Cmd_Hex[0], RF_Cmd_Hex[1], RF_Cmd_Hex[2]);
    printf("RH_Cmd  %d  %d  %d\n", RH_Cmd_Hex[0], RH_Cmd_Hex[1], RH_Cmd_Hex[2]);
    printf("LH_Cmd  %d  %d  %d\n\n", LH_Cmd_Hex[0], LH_Cmd_Hex[1], LH_Cmd_Hex[2]);
#endif
            Flag_4 = 0;                 //clear pending
            //Task_4 = 0;
        }
    }
}
//■■■■■■■■■■■■■■■■■■■■■■■■■■■end of main funtion■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■//


//≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡Timebase funtion≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡//
void init_TIMER()                       //set TT_main{} rate
{
    TT.attach_us(&TT_main, Rms);
}
void TT_main()                          //interrupt function by TT
{
    Task_3_count = Task_3_count + 1;
    if(Task_3_count > Task_3_NN) {
        Task_3_count = 0;               //Task triggering
        Flag_3 = 1;
    }
    
    Task_4_count = Task_4_count + 1;
    if(Task_4_count > Task_4_NN) {
        Task_4_count = 0;               //Task triggering
        Flag_4 = 1;
    }
}
//■■■■■■■■■■■■■■■■■■■■■■■■■■■end of Timebase funtion■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■//


//≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡Rx_irq funtion≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡//
void    Rx_irq(void)
{
    Buff[0] = Debug.getc();
    Debug.putc(Buff[0]);
}
//■■■■■■■■■■■■■■■■■■■■■■■■■■■end of Rx_irq funtion■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■//


//≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡Button funtion≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡//
void    pressed(void)
{
    walking = !walking;
}

void    released(void)
{
    
}
//■■■■■■■■■■■■■■■■■■■■■■■■■■■end of button funtion■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■//


//≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡Walk funtion≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡//
void    init_posture()
{
    //leg 1
    pawCoordinate[0][0] = BODYLENGTH;
    pawCoordinate[0][1] = BODYWIDTH;
    pawCoordinate[0][2] = 0;
    //leg 2
    pawCoordinate[1][0] = BODYLENGTH;
    pawCoordinate[1][1] = 0;
    pawCoordinate[1][2] = 0;
    //leg 3
    pawCoordinate[2][0] = STEPLENGTH;
    pawCoordinate[2][1] = 0;
    pawCoordinate[2][2] = 0;
    //leg 4
    pawCoordinate[3][0] = 0;
    pawCoordinate[3][1] = BODYWIDTH;
    pawCoordinate[3][2] = 0;
    
    //calculate paws' centroid
    calTriCentroid(pawCoordinate[0], pawCoordinate[2], pawCoordinate[3], pawCentroid);
    
    //left front body
    bodyCoordinate[0][0] = pawCentroid[0] + BODYLENGTH/2;
    bodyCoordinate[0][1] = BODYWIDTH;
    bodyCoordinate[0][2] = BODYHEIGHT;
    //right front body
    bodyCoordinate[1][0] = pawCentroid[0] + BODYLENGTH/2;
    bodyCoordinate[1][1] = 0;
    bodyCoordinate[1][2] = BODYHEIGHT;
    //right rear body
    bodyCoordinate[2][0] = pawCentroid[0] - BODYLENGTH/2;;
    bodyCoordinate[2][1] = 0;
    bodyCoordinate[2][2] = BODYHEIGHT;
    //left rear body
    bodyCoordinate[3][0] = pawCentroid[0] - BODYLENGTH/2;;
    bodyCoordinate[3][1] = BODYWIDTH;
    bodyCoordinate[3][2] = BODYHEIGHT;
    
    //calculate body centroid
    calRecCentroid(bodyCoordinate, bodyCentroid);
    
    convertToPolar(bodyCoordinate, pawCoordinate, legLength, legAngle);
    
    stepIncrement = (MOVESPEED/(1e6))*(Rms*(Task_3_NN + 1));
#if DEBUG
    for(int i=0; i<4; i++)
    {
        Debug.printf("leg %d X %f Y %f Z %f Length %f Angle %f\n", 
        i+1, pawCoordinate[i][0], 
        pawCoordinate[i][1], pawCoordinate[i][2], 
        legLength[i], legAngle[i][1]);    
    }

    Debug.printf("%f %f %f\n", pawCentroid[0], pawCentroid[1], pawCentroid[2]);
    Debug.printf("%f %f %f\n", bodyCentroid[0], bodyCentroid[1], bodyCentroid[2]);
    Debug.printf("%f %f %f %f\n", legLength[0], legLength[1], legLength[2], legLength[3]);
    Debug.printf("%f %f %f %f\n", legAngle[0][1], legAngle[1][1], legAngle[2][1], legAngle[3][1]);
#endif
}

void    walk(void)
{
    if(liftLegBool)
    {
        liftLeg(stepOrder[stepOrderIdx]-1);
    }   
    if(forwardLegBool)
    {
        forwardLeg(stepOrder[stepOrderIdx]-1);
    } 
    if(dropLegBool)
    {
        dropLeg(stepOrder[stepOrderIdx]-1);
    } 
    if(moveCentroidBool)
    {
        moveCentroid(stepOrder[stepOrderIdx]-1);
    } 
    
    //calculate body centroid
    calRecCentroid(bodyCoordinate, bodyCentroid);
    
    convertToPolar(bodyCoordinate, pawCoordinate, legLength, legAngle);
#if DEBUG == 1
    Debug.printf("leg %d X %f Y %f Z %f Length %f Angle %f\n", 
        stepOrder[stepOrderIdx], pawCoordinate[stepOrder[stepOrderIdx]-1][0], 
        pawCoordinate[stepOrder[stepOrderIdx]-1][1], pawCoordinate[stepOrder[stepOrderIdx]-1][2], 
        legLength[stepOrder[stepOrderIdx]-1], legAngle[stepOrder[stepOrderIdx]-1][1]);
#endif
}

void liftLeg(uint8_t leg)
{
    if(!inLoopFlag1)    //do when enter the loop first time
    {
        liftCounter = STEPHEIGHT/stepIncrement;
        inLoopFlag1 = true;
        //Debug.printf("lift leg\n");
    }
    pawCoordinate[leg][2] += stepIncrement; //increase z coordinate
    liftCounter--;
    if(liftCounter == 0)
    {
        liftLegBool = false;    
        inLoopFlag1 = false;    //leave loop
        forwardLegBool = true;
    }
}

void forwardLeg(uint8_t leg)
{
    if(!inLoopFlag2)
    {
        forwardCounter = (bodyCoordinate[leg][0]-pawCoordinate[leg][0]+STEPLENGTH)/stepIncrement;   //step forward to exceed body step length
        inLoopFlag2 = true;
        //Debug.printf("leg forward\n");
    }
    pawCoordinate[leg][0] += stepIncrement; //increase x coordinate
    forwardCounter--;
    if(forwardCounter == 0)
    {
        forwardLegBool = false;    
        inLoopFlag2 = false;
        dropLegBool = true;
    }
}

void dropLeg(uint8_t leg)
{
    if(!inLoopFlag3)    //do when enter the loop first time
    {
        dropCounter = STEPHEIGHT/stepIncrement;
        inLoopFlag3 = true;
        //Debug.printf("drop leg\n");
    }
    pawCoordinate[leg][2] -= stepIncrement; //decrease z coordinate
    dropCounter--;
    if(dropCounter == 0)
    {
        dropLegBool = false;    
        inLoopFlag3 = false;    //leave loop
        moveCentroidBool = true;
    }
}

void moveCentroid(uint8_t leg)
{
    if(!inLoopFlag4)    //do when enter the loop first time
    {
        switch(leg) //calculate paws' centroid
        {
            case 0:                           
                calTriCentroid(pawCoordinate[0], pawCoordinate[1], pawCoordinate[3], pawCentroid);
                break;
            case 1:
                calTriCentroid(pawCoordinate[0], pawCoordinate[1], pawCoordinate[2], pawCentroid);
                break;  
            case 2:
                calTriCentroid(pawCoordinate[0], pawCoordinate[2], pawCoordinate[3], pawCentroid);
                break;  
            case 3:
                calTriCentroid(pawCoordinate[1], pawCoordinate[2], pawCoordinate[3], pawCentroid);
                break;      
        }

        centroidCounter = abs((pawCentroid[0] - bodyCentroid[0])/stepIncrement);
        inLoopFlag4 = true;
        //Debug.printf("move the centroid\n");
    }
    for(int i = 0; i<4; i++)
    {
        if(pawCentroid[0] >= bodyCentroid[0])
        {
            bodyCoordinate[i][0] += stepIncrement;
        }
        else
        {
            bodyCoordinate[i][0] -= stepIncrement;
        }
        
    }
    centroidCounter--;
    if(centroidCounter == 0)
    {
        moveCentroidBool = false;    
        inLoopFlag4 = false;    //leave loop
        liftLegBool = true;
        stepOrderIdx = (++stepOrderIdx)%4;  //switch leg according to step order
    }
}

void    convertToPolar(float (&bodyCoordinate)[4][3], float (&pawCoordinate)[4][3], float (&legLength)[4], float (&legAngle)[4][2])
{
    int temp;
    
    for(int i = 0; i<4; i++)
    {
        for(int j = 0; j<3; j++)
        {
            legLength[i] += pow((pawCoordinate[i][j] - bodyCoordinate[i][j]), 2);
        }
        legLength[i] = sqrt(legLength[i]);  //leglength = sqrt(deltaX^2 + deltaY^2 + deltaZ^2)
        temp = sqrt(pow(pawCoordinate[i][1] - bodyCoordinate[i][1], 2) + pow(pawCoordinate[i][2] - bodyCoordinate[i][2], 2));   //temp = sqrt(deltaY^2 + deltaZ^2) 
        legAngle[i][0] = atan((pawCoordinate[i][1] - bodyCoordinate[i][1]) / (bodyCoordinate[i][2] - pawCoordinate[i][2])); //angle1 = arctan(deltaY / deltaZ)
        legAngle[i][1] = atan((pawCoordinate[i][0] - bodyCoordinate[i][0]) / temp); //angle2 = arctan(deltaX / temp)
    }  
}

void    calTriCentroid(float (&point1)[3], float (&point2)[3], float (&point3)[3], float (&centroid)[3])
{
    for(int i = 0; i<3; i++)
    {
        centroid[i] = (point1[i] + point2[i] + point3[i])/3;    
    }
}

void    calRecCentroid(float (&points)[4][3], float (&centroid)[3])
{
    for(int i = 0; i<3; i++)
    {
        centroid[i] = (points[0][i] + points[1][i] + points[2][i] + points[3][i] )/4;    
    }
}
//■■■■■■■■■■■■■■■■■■■■■■■■■■■end of walk funtion■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■//

//≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡Command funtion≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡≡//

void converToHexCmd()
{
    LF_Cmd_Hex[0] = ((legAngle[0][0]+(ANGLE1RANGE/2))/ANGLE1RANGE)*255;
    LF_Cmd_Hex[1] = ((legAngle[0][1]+(ANGLE2RANGE/2))/ANGLE2RANGE)*255;
    LF_Cmd_Hex[2] = (legLength[0]-MINLEGLENGTH)/(MAXLEGLENGTH-MINLEGLENGTH)*255;    
    
    RF_Cmd_Hex[0] = ((legAngle[1][0]+(ANGLE1RANGE/2))/ANGLE1RANGE)*255;
    RF_Cmd_Hex[1] = ((legAngle[1][1]+(ANGLE2RANGE/2))/ANGLE2RANGE)*255;
    RF_Cmd_Hex[2] = (legLength[1]-MINLEGLENGTH)/(MAXLEGLENGTH-MINLEGLENGTH)*255;
    
    RH_Cmd_Hex[0] = ((legAngle[2][0]+(ANGLE1RANGE/2))/ANGLE1RANGE)*255;
    RH_Cmd_Hex[1] = ((legAngle[2][1]+(ANGLE2RANGE/2))/ANGLE2RANGE)*255;
    RH_Cmd_Hex[2] = (legLength[2]-MINLEGLENGTH)/(MAXLEGLENGTH-MINLEGLENGTH)*255;
    
    LH_Cmd_Hex[0] = ((legAngle[3][0]+(ANGLE1RANGE/2))/ANGLE1RANGE)*255;
    LH_Cmd_Hex[1] = ((legAngle[3][1]+(ANGLE2RANGE/2))/ANGLE2RANGE)*255;
    LH_Cmd_Hex[2] = (legLength[3]-MINLEGLENGTH)/(MAXLEGLENGTH-MINLEGLENGTH)*255;
}

//■■■■■■■■■■■■■■■■■■■■■■■■■■■end of command funtion■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■//