#include "mbed.h"

#include "LM75B.h"

#include "C12832_lcd.h"
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);
C12832_LCD lcd;
LM75B tmp(p28,p27);

int main ()
{
    while (1) {
        lcd.cls();
        lcd.locate(0,3);
        　//define the primary position of display.
        lcd.printf("Room Temp. :%.2foC",tmp.read()); //output char.
        wait(0.1);
        for(float i = 0.0; i < 1.0 ; i += 0.01) {
            float p = (((tmp.read()/100)-0.298)*60); //define the variation of color.
            r = 1.0 - ((p < 1.0) ? 1.0 - p : (p > 2.0) ? p - 2.0 : 0.0);
            g = 1.0 - ((p < 1.0) ? p : (p > 2.0) ? 0.0 : 2.0 - p);
            b = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);  ;
            wait (0.01);
        }

    }
}