#include "mbed.h"
#include "MPU6050.h"
SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
Serial a(USBTX,USBRX);
MPU6050 Wire(PB_9,PB_8); //SDA&SCL
InterruptIn iz(PA_14);
InterruptIn de(PA_13);
#define  uint8_t unsigned char
float q[3];
int pos;
float vel=200;
int b;
uint8_t cam[3]={0b01100000,0b00011000,0b00000110};
uint8_t Matr[9]={0,0,0,0,0,0,0,0,0};
uint8_t entorno={0b10000001};
uint8_t carro={0b00011000};
uint8_t obs=0b01100000;
void derecha();
void izquierda(); 
void colision();
void juego();
void accelerometro();
void cambio();
void vell();
int con=0;
int az;
////////////////////////////////////////
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock(); 
}
////////////////////////////////////////
void borrar()
{
 for(int i;i<=8;i++)   {
     sendSPI(i,0);
     }
}
///////////////////////////////////////
void inicializar(){
                    a.baud(9600);
                    sendSPI(0x0c,1);
                    sendSPI(0x09,0);
                    sendSPI(0x0A,0x01);
                    sendSPI(0x0F,1);
                    wait (0.5);
                    sendSPI(0x0F,0);
                    wait(0.5);
                    sendSPI(0xB,0x7);    
                    borrar();
                    vel=200;
                    carro=0b00011000;
    }
//////////////////////////////////////////
void imprimir()
{
    int c_d; //carro, obstaculo y entorno
    int c_e; //carro y entorno
    int din;
    for(int i=1;i<=7;i++){
             sendSPI(i,entorno);
              }
   for(int j=1;j<=10;j++){
             din=(obs>>b) | entorno  ;
             c_d= carro | din;
             c_e=carro | entorno;
             sendSPI(8,c_e);
             if(j<=7){   
             sendSPI(j,din);
             }
             
             if(j>1 && j<=8)
             sendSPI(j-1,din);
                 
             if(j>2 && j<=9){
             sendSPI(j-2,entorno);
             }
             if(j>=8&&j<=9){
                 sendSPI(8,c_d);
                 }
             if(j>10){
                 sendSPI(8,c_e);
                 }
            
             if( (obs>>b)==carro && j==8 ){
               colision();
                 }
             accelerometro();
             cambio();
             wait_ms(vel);
    }
}
//////////////////////////////////////////
int main() {
     while(1){
     juego();        
        }
}
///////////////////////////////////////////
void juego(){
                    inicializar();   
                    //de.rise(&derecha);  
                    //iz.rise(&izquierda);  
                    a.printf("inicio\n");
                    while(1){
                    b=2*(rand()%3);
                    a.printf("umero %d\n",az);
                    imprimir();
                    vell();  
                    }
             }
///////////////////////////////////
void derecha()
{
    if(carro==0b00011000 || carro==0b01100000)
    carro=carro>>2;
    a.printf("entra der \n");
    return;
}
///////////////////////////////////
void izquierda()
{
    if( carro==0b00000110 ||  carro==0b00011000  )
    carro=carro<<2;
    a.printf("entra izq \n");
    return;
}
////////////////////////////////////
void cambio(){
    switch(az){
        case 1: carro = cam[0];break;
        case 2: carro = cam[1];break;
        case 3: carro = cam[2];break;
        default: break;}
    
    }
////////////////////////////////////
void colision ()
{
                 borrar();  
                 sendSPI(0x0F,0);
                 sendSPI(3,0b01111110);
                 sendSPI(4,0b01111110);
                 sendSPI(5,0b01111110);
                 sendSPI(6,0b01111110);
                 con=0;
                 vel=200;
                 wait(2);
                 juego();
}
/////////////////////////////////////
void accelerometro(){
         Wire.getAccelero(q);
         a.printf("accelero: \t x=  %f,\t y=  %f, \t z= %f \n",q[0],q[1],q[2]);
         int valor=q[1];
         if(valor<=(-4) && valor>=(-10)){
           az=1;}
         if(valor<(4) && valor>=(-4)){
           az=2;}
         if(valor<(10) && valor>=(4)){
           az=3;}
         a.printf("az : \t  %d \n",az);
    }
/////////////////////////////////////
void vell(){
    con++;
    if(con>2 && vel>=20)
    {
    vel=vel-(vel*0.2);
    }
    }