/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name:     Omar Alebiary
Username: el17oa
ID :      201172644
Date:     15/3/2019
*/
#include "RocketRacer.h"
#include "Menus.h"
#include "tests.h"

// objects 
// create object and specifiy pins
FXOS8700CQ devicee(I2C_SDA,I2C_SCL);
//instantiating the Gamepad object 
Gamepad pad;

// instantiating the RocketRacer object 
RocketRacer Rocket_Racer;

//instantiating the lcd object and assigning the pins on the gamepad to it
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11); 

//instantiating the Menus object
Menus menus;

// instantiating the tests object 
tests test;


// prototypes
/**
  * @brief object initialization method
  * @param None @details method that initializes objects like lcd,gampad and device(for accelerometer)and
  * sets the default contrast of the lcd and brightness 
  */
void setup();
/**
  * @brief main method
  * @param None @details main method that has all the method calls of the Menus.cpp and 
  * the RocketRacer class and has the Game_Loop method that runs the game
  */
int main();



void setup(){
    
    lcd.init();//initialize the lcd
    pad.init();//initialize the pad
    lcd.clear();
    lcd.setBrightness(0.4);//sets the default brightness
    lcd.setContrast(0.55);//set the default contrast
    lcd.normalMode();
    devicee.init();
    
    }
    

    
    
int main(){
    
    
    setup();//initializes all the objects
   
    menus.welcomeMenu(pad,lcd);//displays the welcome menu
    menus.loading_menu(lcd);//displays the loading menu next
    pad.leds_off();//turns off the leds
    //calls the drawMenu which has the main menus and the game loop
    while(1){ //infinite loop
    menus.drawMenu(lcd,pad);
    }
    
}

