#ifndef GAMETONES_H
#define GAMETONES_H
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
 
 
 /** GameTones class 

@brief C++ class containing the tones for the gameplay

@version 1.0

@author Omar Alebiary

@date April 2019

@code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "RocketRacer.h"

// objects 
Gamepad pad;
RocketRacer rc;
Menus menus;
GameTones tones;



int main(){
    
     //initializes the gamepad and the lcd 
     setup();
     //plays costume made tones for the end of game display
     tones.End_Game_Melody(pad);
     //plays costume made tones for the welcome screen
     tones.Play_Welcome_Melody(pad);
    
}

@endcode
*/
  
  
class GameTones{
    
    public:
    /**
  * @brief Default Constuctor
  * @details Creates the object of class GameTones
  */
    GameTones();
    /**
  * @brief Default destuctor
  * @details destroys the object of class GameTones
  */
    ~GameTones();
    /**
  * @brief method to play the game over melody
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  */
  void End_Game_Melody(Gamepad &pad);
  /**
  * @brief method to play the welcome melody
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  */
  void Play_Welcome_Melody(Gamepad &pad);
  
};

#endif