#ifndef TESTS_H
#define TESTS_H
#include "RocketRacer.h"
#include "Menus.h"
#include "GameTones.h"

 
 /** tests class

@brief C++ class containing the tests for methods

@version 1.0

@author Omar Alebiary

@date April 2019

@code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "RocketRacer.h"

// objects 
Gamepad pad;
RocketRacer rc;
Menus menus;
tests test;



int main(){
    
    
     setup();
     while(1){
//     test.test_welcomeMenu(pad,lcd);
//     test.test_Play_Welcome_Melody(pad);
//     test.test_End_Game_Melody(Gamepad &pad);
//     test.test_drawMenu(lcd, pad);
//     test.test_credits_page(lcd,pad);
//     test.test_loading_menu(lcd);
//     test.test_InstructionsMenu(pad,lcd);
//     test.test_Game_Loop(pad,lcd);
//     test.test_Joystick_position(pad);
//     test.test_Generate_New_Enemy();
//     test.test_Joystick_position(pad);
//     test_check_button_pressed(pad,lcd);
      test.test_accelerometer_position(pad);
     }
    
    
    

}

@endcode
*/
  
  
class tests{
    
    public:
    /**
  * @brief Default Constructor
  *  @details Creates the object of class tests
  */
    tests();
     /**
  * @brief Default destructor
  *  @details destroys the object of class tests
  */
    ~tests();
    /**
  * @brief method to test welcome menu
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  */
  void test_welcomeMenu(Gamepad &pad,N5110 &lcd);
  /**
  * @brief method to test tones played in the game
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  */ 
  void test_Play_Welcome_Melody(Gamepad &pad);
  /**
  * @brief method to test tones played in the game over screen
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  */ 
  void test_End_Game_Melody(Gamepad &pad);
  /**
  * @brief method to test  the draw main menu method
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  */ 
  void test_drawMenu(N5110 &lcd,Gamepad &pad);
  /**
  * @brief method to test  the credits page on the menu
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  */ 
  void test_credits_page(N5110 &lcd,Gamepad &pad);
  /**
  * @brief method to test  the loading page
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  */ 
  void test_loading_menu(N5110 &lcd);
  /**
  * @brief method to test  the instructions page
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  */ 
  void test_InstructionsMenu(Gamepad &pad,N5110 &lcd);
  /**
  * @brief method to test  the game loop which has all the game methods calls in it 
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  */
  void test_Game_Loop(Gamepad &pad,N5110 &lcd);
  /**
  * @brief method to test  the position of the joystick and prints its current state and return true
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  */
  bool test_Joystick_position(Gamepad &pad);
  /**
  * @brief method to test generated numbers
  * @details it tests if the randomly genrated number is 1,2 or 3 
  * @returns true if the condition is met, false otherwise 
  */
  bool test_Generate_New_Enemy();
  /**
  * @brief method to test  the position of the accelerometer and prints its current state and return true
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  * @returns true if the condition is met, false otherwise 
  */
  bool test_accelerometer_position(Gamepad &pad);
  /**
  * @brief method to test button presses in the menu and return true, false otherwise
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  * @returns true if the condition is met, false otherwise  
  */
  bool test_check_button_pressed(Gamepad &pad,N5110 &lcd);
  
  private:
  Menus menu;
  RocketRacer Rocket_Racing;
  GameTones Game_Tones;
  
};

#endif