#include "tests.h"


//default constructor of the class
tests::tests(){   
}

//destructor of the class
tests::~tests(){
    
}

//calls the welcome menu to be tested
void tests::test_welcomeMenu(Gamepad &pad,N5110 &lcd){
    menu.welcomeMenu(pad,lcd);
}

//calls the play wecome melody to be tested
void tests::test_Play_Welcome_Melody(Gamepad &pad){
    Game_Tones.Play_Welcome_Melody(pad);
}

//tests the end of game display
void tests::test_End_Game_Melody(Gamepad &pad){
    Game_Tones.End_Game_Melody(pad);
}

//tests the draw menu screen
void tests::test_drawMenu(N5110 &lcd,Gamepad &pad){
    menu.drawMenu(lcd,pad);
}
 //tests the credits page in the menu   
void tests::test_credits_page(N5110 &lcd,Gamepad &pad){
    menu.credits(lcd,pad);
}

//tests the loading page after the welcome menu
void tests::test_loading_menu(N5110 &lcd){
    menu.loading_menu(lcd);
}

//tests the instructions
void tests::test_InstructionsMenu(Gamepad &pad,N5110 &lcd){
    menu.InstructionsMenu(pad,lcd);
}

//tests the joystick position in the game
bool tests::test_Joystick_position(Gamepad &pad){

    Direction d=pad.get_direction();//assigning the object d to the method to get the joystick direction

    if( (d==E||pad.check_event(Gamepad::R_PRESSED) == true )){//statement to check if the joystick moved right  
        printf("its Right\n");//prints its right on the coolterm 
        return true;// returns true if the condition is met
    }
    else if( (d==W ||pad.check_event(Gamepad::L_PRESSED) == true )){//statement to check if the joystick moved left
        printf("its left\n");//prints its left on the coolterm 
        return true;// returns true if the condition is met
    }
    else if(d==CENTRE){//statement to check if the joystick position is center
        printf("its center\n");//prints its centre on the coolterm 
        return true;// returns true if the condition is met
        }
        return false;// returns false if all the conditions are not met
}

//tests the randomly genrated enemy 
bool tests::test_Generate_New_Enemy(){
  
    srand(time(NULL));//seeding the random function
    
    int second_enemy_position = (rand() % 3)+1;//generates a random number from 1 to 3 
    printf("%d",second_enemy_position);//return true if random generated number is between(1->3)
    if(second_enemy_position==1||second_enemy_position==2||second_enemy_position==3){
        return true;// returns true if any of the conditions are met
    }
    return false;// returns false if none of the conditions are met
}

//testing game loop
void tests::test_Game_Loop(Gamepad &pad,N5110 &lcd){
    while(1){//inifinite loop to test the gameplay
        Rocket_Racing.Game_Loop(lcd,pad);
    } 
}

// create object and specifiy pins
FXOS8700CQ deviceee(I2C_SDA,I2C_SCL);

bool tests::test_accelerometer_position(Gamepad &pad){
    //calls the get_pitch_angle method to get angles
    float pitchAngle = deviceee.get_pitch_angle();
    //statement to check if the gamepad rolled to the right
    if( (pitchAngle > 100)){
        return true;
//        printf("its Right\n");
    }
    //statement to check if the gamepad rolled to the left
    else if( (pitchAngle < 90 )){
        return true;
//        printf("its left\n");
    }
    else {//returns false if not rolled right or left
        return false;
    }    
}


bool tests::test_check_button_pressed(Gamepad &pad,N5110 &lcd){  
    if (pad.check_event(Gamepad::A_PRESSED) == true){//if A presed 
      printf("A pressed working");   
      return true;//returns true if condition met
    }else if (pad.check_event(Gamepad::B_PRESSED) == true){//if B presed
      printf("B pressed working");  
      return true;//returns true if condition met
    }else if (pad.check_event(Gamepad::Y_PRESSED) == true){//if Y presed
      printf("Y pressed working");  
      return true;//returns true if condition met
    }else if (pad.check_event(Gamepad::X_PRESSED) == true){//if X presed
      printf("X pressed working");  
      return true;//returns true if condition met
    }
    return false;//returns false if condition not met   
}