#ifndef MENUS_H
#define MENUS_H
#include "RocketRacer.h"
#include "GameSprites.h"
#include "GameTones.h"
 
 /** Menus class

@brief C++ class containing the game menus and the interface

@version 1.0

@author Omar Alebiary

@date April 2019

@code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "RocketRacer.h"

// objects 
Gamepad pad;
RocketRacer rc;
Menus menus;



int main(){
    
    
    setup();
    //displays the welcome menu
    menus.welcomeMenu(pad,lcd); 
    //displays the instructions menu
    menus.InstructionsMenu(pad,lcd);
    //displays the 2nd instructions menu
    menus.SecondInstructionsMenu(lcd);
    //displays the loading menu
    menus.loading_menu(lcd);
    //displays the credits menu
    menus.credits(lcd,pad);
    //keeps looping to display main menu and method calls
    while(1){
        //displays main menu and each related method call when button pressed 
        menus.drawMenu(lcd,pad); 
    }


}

@endcode
*/
  
  
class Menus{
    
    public:
    /**
  * @brief default constructor
  */
    Menus();
    /**
  * @brief default destructor
  */
    ~Menus();
    /**
  * @brief welcome menu method
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  */
  void welcomeMenu(Gamepad &pad,N5110 &lcd);
   /**
  * @brief instructions menu method
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  */
  void InstructionsMenu(Gamepad &pad,N5110 &lcd);
  
  /**
  * @brief draw menu method that draws the main menu
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  */ 
  void  drawMenu(N5110 &lcd,Gamepad &pad);
  /**
  * @brief method that displays credits of the owner of the game
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  */  
  void  credits(N5110 &lcd,Gamepad &pad);
  /**
  * @brief method that checks buttons pressed in the main menu
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  */ 
  void  check_button_pressed(Gamepad &pad,N5110 &lcd);
  /**
  * @brief method that draws loading bar
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  */ 
  void  loading_menu(N5110 &lcd);
  /**
  * @brief second instructions menu method
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  */
  void SecondInstructionsMenu(N5110 &lcd);
  
  private:
  RocketRacer Rocket_Race;
  GameTones tone;
  
  
};

#endif