#include "Menus.h"


//default constructor of the class
Menus::Menus(){
}

//destructor of the class
Menus::~Menus(){
}

//dispalys the welcome menu
void Menus::welcomeMenu(Gamepad &pad,N5110 &lcd) {
    
    lcd.printString(" Rocket Racer   ",0,0);  
    
    lcd.drawSprite(25,8,11,9,(int *)enemyMainMenu);//prints sprites on the welcome menu
    lcd.drawSprite(45,15,11,9,(int *)enemyMainMenu);
    lcd.drawSprite(35,31,11,9,(int *)rocketMainMenu);
    lcd.drawLine(20, 10, 20,45,1);//draws lines
    lcd.drawLine(22, 10, 22,45,2);
    lcd.drawLine(57, 10, 57,45,1);
    lcd.drawLine(55, 10, 55,45,2);
    
    pad.leds_on();//turns all leds on
    lcd.refresh();
    tone.Play_Welcome_Melody(pad);//plays a melody
    wait(1); 
 
}

//dispalys the main menu 
void Menus::drawMenu(N5110 &lcd,Gamepad &pad) {
  
  lcd.clear();
  lcd.printString("MAIN MENU", 15, 0);
  lcd.drawLine(1, 10,80 ,10,1);
  lcd.printString("Play       -A", 2, 2);
  lcd.printString("Play /acc  -Y", 2, 3);
  lcd.printString("Instructions-B", 1, 4);
  lcd.printString("Credits    - X", 1, 5);
  pad.leds_off();
  wait(0.1);
  pad.leds_on(); 
  wait(0.1);
  lcd.refresh();
  //calls this method to check button press for each item in the menu
  check_button_pressed(pad,lcd);
          
}

//checks if a button pressed and calls the subsequent method
void Menus::check_button_pressed(Gamepad &pad,N5110 &lcd){  
    if (pad.check_event(Gamepad::A_PRESSED) == true){//if A presed 
      pad.leds_off();
      while(pad.check_event(Gamepad::BACK_PRESSED) == false){//loop since back not pressed
        Rocket_Race.Game_Loop(lcd,pad);//call the game loop
        }
    }else if (pad.check_event(Gamepad::B_PRESSED) == true){//if B presed
      InstructionsMenu(pad,lcd);//call the instructions menu
      if (pad.check_event(Gamepad::BACK_PRESSED) == true){//if BACK presed
      drawMenu(lcd,pad);//returns back to the main menu
      }
    }else if (pad.check_event(Gamepad::Y_PRESSED) == true){//if Y presed
      pad.leds_off();
      while(pad.check_event(Gamepad::BACK_PRESSED) == false){//loop since back not pressed
        Rocket_Race.Game_Loop_accelerometer(lcd,pad);//call the game loop with accelerometer control
      }
    }else if (pad.check_event(Gamepad::X_PRESSED) == true){//if X presed
      credits(lcd,pad);//call the credits page
      if (pad.check_event(Gamepad::BACK_PRESSED) == true){
      drawMenu(lcd,pad);//returns back to the main menu
      }
    }    
}

//displays credits menu
void Menus::credits(N5110 &lcd,Gamepad &pad) {
  
  lcd.clear();
  //prints strings on the lcd
  lcd.printString("Game By:", 8, 1);
  lcd.printString("Omar Alebiary", 7, 2);
  lcd.printString("ID: 201172644", 7, 3);
  
  lcd.printString("< press BACK ", 12, 5);
   
  lcd.refresh();
  wait(0.5);
  while ( pad.check_event(Gamepad::BACK_PRESSED) == false){//keep looping since back not pressed
        pad.leds_on();//turn all leds on
        wait(0.1);
        pad.leds_off();//turn all leds off
        wait(0.1);        
    }
  
}

//displays loading page
void Menus::loading_menu(N5110 &lcd) {
  lcd.clear();
  lcd.printString("loading...", 2, 1);
  
  lcd.drawLine(7, 20,12 ,20,1);
  lcd.refresh();
  wait(0.6); 
  lcd.drawLine(7, 20,24 ,20,1);
  lcd.refresh();
  wait(0.5);
  lcd.drawLine(7, 20,34 ,20,1);
  lcd.refresh();
  wait(0.6); 
  lcd.drawLine(7, 20,44,20,1);
  lcd.refresh();
  wait(0.2);
  lcd.drawLine(7, 20,65 ,20,1);
  lcd.refresh();
  wait(0.2);
}

//displays the second instructionsmenu
void Menus::SecondInstructionsMenu(N5110 &lcd){
    lcd.clear();
    lcd.printString("U can also use",0,0); 
    lcd.printString("accelormeter",0,1);
    lcd.printString("to control ",0,2);
    lcd.printString("the rocket ",0,3);
    lcd.printString("in play/acc",0,4);
    
    lcd.printString("< press BACK ", 12, 5);
    lcd.refresh();
}
   
      
void Menus::InstructionsMenu(Gamepad &pad,N5110 &lcd){
    
    lcd.clear();
    lcd.printString("How to play:",0,0); 
    lcd.printString("Use joystick",0,1);
    lcd.printString("or L & R",0,2);
    lcd.printString("to escape ",0,3);
    lcd.printString("enemies.",0,4);
    lcd.refresh();
    wait(3);
    SecondInstructionsMenu(lcd);
    
    lcd.refresh();
    wait(1);
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false){//keep looping since back not pressed
        pad.leds_on();//turn all leds on
        wait(0.1);
        pad.leds_off();//turn all leds off
        wait(0.1);
        
    }      
}
    
  
 
    
    