#ifndef ROCKETRACER_H
#define ROCKETRACER_H
#include "mbed.h"
#include "N5110.h"
#include <cstdlib> 
#include <ctime> 
#include "Gamepad.h"
#include "GameSprites.h"
#include "GameTones.h"
#include "FXOS8700CQ.h"

/** RocketRacer class

@brief University of Leeds,C++ class containing the game methods and the interface

@version 1.0

@author Omar Alebiary

@date April 2019

@code
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "RocketRacer.h"

// objects 
Gamepad pad;
RocketRacer Rocket_Racer;


// prototypes
void setup();

int main(){
    
    //initializes the gamepad and the lcd 
    setup();
    
//  this method displays the game scoresand frames
//  used in the gameplay
    
    Rocket_Racer.Main_Game_Display(lcd);
//  this method checks the accelerometer state
//  if it rolled right prints "its right" else if it rolled 
//  left prints "its left" else prints "centre" 
    Rocket_Racer.accelerometer_position(pad);
    
//  this method checks the joystick position
//  if it's right prints "its right" else if its 
//  left prints "its left" else prints "centre"  
     Rocket_Racer.Joystick_position(pad);
    //this method generates a random number between 1 and 3
    //and prints it to the terminal
     Rocket_Racer.Generate_New_Enemy();
    //this method checks if the rocket collide with the enemy
    //and displays game over screen 
     Rocket_Racer.Check_Enemy_Dead(lcd,pad);
    //main game loop that has all the method calls in it 
    while(1){
        Rocket_Racer.Game_Loop(lcd,pad);
    }
    //method that adds difficulty to the game
    //and has 6 levels of difficulty
     Rocket_Racer.Game_difficulty(pad);
     //this method places the enemy sprite according
     //to the randomly generated number(1->3)& the current phase
     //i added the 2nd and 3rd argument manually for testing
     Rocket_Racer.enemy_position(lcd,2,3);
     //this method places the player sprite
     //according to the postion of the joystick 
     //i added the 2nd argument manually for testing
     Rocket_Racer.player_position(lcd, 3);
     //this method displays the gameover screen
     //and the high score achieved
     Rocket_Racer.End_Game(pad,lcd);


}

@endcode
*/


class RocketRacer{
    
    public:
    /**
  * @brief Default Constructor
  *  @details Creates the object of class RocketRacer
  */
    RocketRacer();
    /**
  * @brief Default destructor
  *  @details destroys the object of class RocketRacer
  */
    ~RocketRacer();
    /**
  * @brief method that has all the screen rendering 
  * @param lcd @details calls the lcd object to draw strings and objects on the display
  */
    void Main_Game_Display(N5110 &lcd);
    /**
  * @brief method that dispalys the game over screen with the high score achieved
  * @param lcd @details calls the lcd object to draw strings on the display
  * @param pad @details calls the Gamepad object to access methods from the Gamepad class
  */
    void End_Game(Gamepad &pad,N5110 &lcd);
    
    /**
  * @brief method that adds difficulty to the game after proceeding each level 
  * @param pad @details calls the Gamepad object to access methods from the Gamepad class
  */
    void Game_difficulty(Gamepad &pad);
    
    /**
  * @brief method that generates random enemies 
  * @param none @details seeds the rand function then generate a random enemies
  */
    void Generate_New_Enemy();
    /**
  * @brief method that checks if the randomly generated enemies crossed the player 
  *       and calls the End_Game method accordingly if they collide else increments the score  
  * @param lcd @details calls the lcd object to be passed to the End_Game method
  * @param pad @details calls the Gamepad object to be passed to the End_Game method
  */
    void Check_Enemy_Dead(N5110 &lcd,Gamepad &pad);
    /**
  * @brief method that checks the joystick (and L &R buttons) direction whether its left,right or centre
  *   and increment or decrement according to the current position  
  * @param pad @details calls the Gamepad object to access the get_direction method from the Gamepad class
  */
    void Joystick_position(Gamepad &pad);
    /**
  * @brief method that has the game loop which calls all the methods(from the same class)for the game to operate 
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  */
    void Game_Loop(N5110 &lcd,Gamepad &pad);
    /**
  * @brief method that draws the rocket sprite according to the player position
  * @param lcd @details calls the lcd object to access the drawSprite method
  * @param RocketPosition @details the position of the rocket 
  */
    void player_position(N5110 &lcd,char RocketPosition);
    /**
  * @brief method that draws the enemy sprite 
  * @param lcd @details calls the lcd object to access the drawSprite method
  * @param place @details the position of the rocket 
  * @param phase @details the phase of the rocket
  */
    void enemy_position(N5110 &lcd,int place, int phase);
    /**
  * @brief Sets the position
  * @param first_enemy_position @details position of the first enemy (as an int)
  */
    void set_first_position(int first_enemy_position);
    /**
  * @brief Sets the position
  * @param second_enemy_position @details position of the second enemy (as an int)
  */
    void set_second_position(int second_enemy_position);
    /**
  * @brief Sets the phase
  * @param enemy_phase @details phase of the enemy (as an int)
  */
    void set_enemy_phase(int enemy_phase);
    /**
  * @brief Sets the game speed
  * @param game_speed @details speed of the game (as an int)
  */
    void set_game_speed(int game_speed);
    /**
  * @brief Sets the game score
  * @param score @details score of the game (as an int)
  */
    void set_game_score(int score);
    /**
  * @brief set enemy dead flag
  * @param enemy_dead @details flag to indicate dead enemy(as a bool)
  */
    void set_enemy_dead(bool enemy_dead) ;
    /**
  * @brief set control flag
  * @param control @details flag for joystick control(as a bool)
  */
    void set_control(bool control);
    /**
  * @brief set initial position
  * @param Init_position @details initial position of the player(as an int)
  */
    void set_init_position(int Init_position);
    /**
  * @brief checks accelerometer positon
  * @param Init_position @details initial position of the player(as an int)
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  */
    void accelerometer_position(Gamepad &pad);
    /**
  * @brief method that has the game loop which calls all the methods and control with accelerometer 
  * @param lcd @details calls the lcd object to be passed to the methods called inside this method
  * @param pad @details calls the Gamepad object to be passed to the methods called inside this method
  */
    void Game_Loop_accelerometer(N5110 &lcd,Gamepad &pad);
    /**
  * @brief method that generates one random enemy
  * @details seeds the rand function then generate a random enemy between 1->3
  */
    void Generate_One_Enemy();
    
    
    
    private:

    int first_enemy_position;
    int second_enemy_position;
    int enemy_phase;
    int game_speed;
    int score;
    float pitchAngle;
    char Init_position;
    bool enemy_dead;
    bool control;
    GameTones tones;
    
    
    
};

#endif